###################################################
### chunk number 1: load library and identify 27k probes
###################################################
#line 32 "hm27kOn450k.Rnw"
library('IlluminaHumanMethylation450k.db')
probes.27k <- IlluminaHumanMethylation450k_get27k()
lapply(probes.27k, function(x) {
  if( class(x) == 'list') lapply(x, head)
  else head(x)
})


###################################################
### chunk number 2: list the 27k probe IDs
###################################################
#line 49 "hm27kOn450k.Rnw"
probes.27k <- unlist(probes.27k, recursive=T)
head(mget(probes.27k, IlluminaHumanMethylation450kPROBELOCATION, ifnotfound=NA))


###################################################
### chunk number 3: annotate the 27k probes
###################################################
#line 60 "hm27kOn450k.Rnw"

probeloc <- mget(probes.27k, IlluminaHumanMethylation450kPROBELOCATION, 
                 ifnotfound=NA)

body.or.exon <- function(x) length( grep('(Body|Exon)', x) ) > 0
length(which(unlist(lapply(probeloc, body.or.exon))))

in.body <- function(x) length( grep('Body', x) ) > 0 
gene.body.probes <- names(which(unlist(lapply(probeloc, in.body))))
length(which(unlist(lapply(probeloc, in.body))))
head(gene.body.probes)


###################################################
### chunk number 4: identify database and package versions
###################################################
#line 81 "hm27kOn450k.Rnw"
IlluminaHumanMethylation450k_dbInfo()[c(8:10,22:24,31,33),]
IlluminaHumanMethylation450kSVNID
IlluminaHumanMethylation450kBLAME


###################################################
### chunk number 5: 
###################################################
#line 92 "hm27kOn450k.Rnw"
toLatex(sessionInfo())


