###################################################
### chunk number 1: 
###################################################
#line 230 "spkDoc.Rnw"
library(spkTools)


###################################################
### chunk number 2: 
###################################################
#line 234 "spkDoc.Rnw"
data(affy)
object <- affy


###################################################
### chunk number 3: 
###################################################
#line 240 "spkDoc.Rnw"
fc=2
label="Affymetrix"
par(mar=c(3,2.5,2,0.5), cex=1.8)


###################################################
### chunk number 4: 
###################################################
#line 250 "spkDoc.Rnw"
spkSlopeOut <- spkSlope(object, label, pch="+")


###################################################
### chunk number 5: 
###################################################
#line 265 "spkDoc.Rnw"
spkDensity(object, spkSlopeOut, cuts=TRUE, label)


###################################################
### chunk number 6: 
###################################################
#line 279 "spkDoc.Rnw"
spkBoxOut <- spkBox(object, spkSlopeOut, fc)
plotSpkBox(spkBoxOut, fc, ylim=c(-1.5,2.5))
sbox <- summarySpkBox(spkBoxOut)


###################################################
### chunk number 7: 
###################################################
#line 298 "spkDoc.Rnw"
spkMA(object, spkSlopeOut, fc, label=label, ylim=c(-2.5,2.5))


###################################################
### chunk number 8: 
###################################################
#line 317 "spkDoc.Rnw"
vtmp <- spkVar(object)
sv <- as.numeric(vtmp[,2][-nrow(vtmp)])
bin <- c("Low", "Med", "High")
bins <- bin[spkSlopeOut$breaks[2,]]
tab1 <- data.frame(NominalConc=2^spkSlopeOut$breaks[1,],
                   AvgExp=round(spkSlopeOut$avgExp,1),
                   PropGenesBelow=round(spkSlopeOut$prop,2),
                   ALEStrata=bins,
                   SD=round(sv,2))
colnames(tab1) <- c("Nominal Conc",
                    "Avg Expression",
                    "Prop of Genes Below",
                    "ALE Strata",
                    "Std Dev")


###################################################
### chunk number 9: 
###################################################
#line 334 "spkDoc.Rnw"
library(xtable)
tab1x <- xtable(tab1)
print(tab1x)


###################################################
### chunk number 10: 
###################################################
#line 353 "spkDoc.Rnw"
AccuracySlope <- round(spkSlopeOut$slopes[-1], digits=2)
AccuracySD <- round(spkAccSD(object, spkSlopeOut), digits=2)
pot <- spkPot(object, spkSlopeOut, AccuracySlope, AccuracySD, 
              precisionQuantile=.995)
PrecisionSD <- round(sbox$madFC[1:3], digits=2)
PrecisionQuantile <- round(pot$quantiles, digits=2)
SNR <- round(AccuracySlope/PrecisionSD, digits=2)
POT <- round(pot$POTs, digits=2)
tab2 <- data.frame(AccuracySlope=AccuracySlope,
                   AccuracySD=AccuracySD,
                   PrecisionSD=PrecisionSD,
                   PrecisionQuantile=PrecisionQuantile,
                   SNR=SNR,
                   POT=POT)


###################################################
### chunk number 11: 
###################################################
#line 369 "spkDoc.Rnw"
tab2x <- xtable(tab2)
print(tab2x)


###################################################
### chunk number 12: 
###################################################
#line 393 "spkDoc.Rnw"
bals <- round(spkBal(object))
anv <- round(spkAnova(object), digits=2)
tab3 <- t(c(anv,bals))


###################################################
### chunk number 13: 
###################################################
#line 398 "spkDoc.Rnw"
tab3x <- xtable(tab3)
print(tab3x)


