###################################################
### chunk number 1: init
###################################################
#line 62 "imputation-vignette.Rnw"
library(snpStats)
library(hexbin)
data(for.exercise)


###################################################
### chunk number 2: select
###################################################
#line 73 "imputation-vignette.Rnw"
training <- sample(1000, 200)
select <- seq(1, ncol(snps.10),2) 
missing <- snps.10[training, select]
present <- snps.10[training, -select] 
missing 
present 


###################################################
### chunk number 3: target
###################################################
#line 85 "imputation-vignette.Rnw"
target <- snps.10[-training, -select]
target


###################################################
### chunk number 4: 
###################################################
#line 92 "imputation-vignette.Rnw"
lost <- snps.10[-training, select]
lost


###################################################
### chunk number 5: positions
###################################################
#line 100 "imputation-vignette.Rnw"
pos.miss <- snp.support$position[select]
pos.pres <- snp.support$position[-select]


###################################################
### chunk number 6: rules
###################################################
#line 115 "imputation-vignette.Rnw"
rules <- snp.imputation(present, missing, pos.pres, pos.miss)


###################################################
### chunk number 7: rule1
###################################################
#line 141 "imputation-vignette.Rnw"
rules[1:10]


###################################################
### chunk number 8: rule2
###################################################
#line 145 "imputation-vignette.Rnw"
rules[c('rs11253563', 'rs2379080')]


###################################################
### chunk number 9: summary
###################################################
#line 154 "imputation-vignette.Rnw"
summary(rules)


###################################################
### chunk number 10: ruleplot
###################################################
#line 165 "imputation-vignette.Rnw"
plot(rules)


###################################################
### chunk number 11: imptest
###################################################
#line 175 "imputation-vignette.Rnw"
imp <- single.snp.tests(cc, stratum, data=subject.support,
                        snp.data=target, rules=rules)


###################################################
### chunk number 12: realtest
###################################################
#line 187 "imputation-vignette.Rnw"
obs <- single.snp.tests(cc, stratum, data=subject.support, snp.data=lost)


###################################################
### chunk number 13: compare
###################################################
#line 195 "imputation-vignette.Rnw"
logP.imp <- -log10(p.value(imp, df=1))
logP.obs <- -log10(p.value(obs, df=1))
hb <- hexbin(logP.obs, logP.imp, xbin=50)
sp <- plot(hb)
hexVP.abline(sp$plot.vp, 0, 1, col="black")


###################################################
### chunk number 14: best
###################################################
#line 208 "imputation-vignette.Rnw"
use <- imputation.r2(rules)>0.9
hb <- hexbin(logP.obs[use], logP.imp[use], xbin=50)
sp <- plot(hb)
hexVP.abline(sp$plot.vp, 0, 1, col="black")


###################################################
### chunk number 15: rsqmaf
###################################################
#line 220 "imputation-vignette.Rnw"
hb <- hexbin(imputation.maf(rules), imputation.r2(rules), xbin=50)
sp <- plot(hb)


###################################################
### chunk number 16: imptest-rhs
###################################################
#line 234 "imputation-vignette.Rnw"
imp2 <- snp.rhs.tests(cc~strata(stratum), family="binomial", 
                      data=subject.support, snp.data=target, rules=rules)
logP.imp2 <- -log10(p.value(imp2))
hb <- hexbin(logP.obs, logP.imp2, xbin=50)
sp <- plot(hb)
hexVP.abline(sp$plot.vp, 0, 1, col="black")


###################################################
### chunk number 17: impstore
###################################################
#line 256 "imputation-vignette.Rnw"
imputed <- impute.snps(rules, target, as.numeric=FALSE)


###################################################
### chunk number 18: uncert1
###################################################
#line 269 "imputation-vignette.Rnw"
plotUncertainty(imputed[, "rs4880568"])


###################################################
### chunk number 19: uncert2
###################################################
#line 273 "imputation-vignette.Rnw"
plotUncertainty(imputed[, "rs2050968"])


###################################################
### chunk number 20: imptest2
###################################################
#line 278 "imputation-vignette.Rnw"
imp3 <- single.snp.tests(cc, stratum, data=subject.support,
                        snp.data=imputed, uncertain=TRUE)


###################################################
### chunk number 21: imp3
###################################################
#line 285 "imputation-vignette.Rnw"
imp3[1:5]
imp[1:5]


###################################################
### chunk number 22: mach
###################################################
#line 302 "imputation-vignette.Rnw"
path <- system.file("extdata/mach1.out.mlprob.gz", package="snpStats")
mach <- read.mach(path)
plotUncertainty(mach[,50])


###################################################
### chunk number 23: class-imp-obs
###################################################
#line 332 "imputation-vignette.Rnw"
class(imp)


###################################################
### chunk number 24: save-scores
###################################################
#line 339 "imputation-vignette.Rnw"
obs <- single.snp.tests(cc, stratum, data=subject.support, snp.data=missing, 
                        score=TRUE)
imp <- single.snp.tests(cc, stratum, data=subject.support,
                        snp.data=target, rules=rules, score=TRUE)


###################################################
### chunk number 25: 
###################################################
#line 346 "imputation-vignette.Rnw"
class(obs)
class(imp)


###################################################
### chunk number 26: pool
###################################################
#line 359 "imputation-vignette.Rnw"
both <- pool(obs, imp)
class(both)
both[1:5]


###################################################
### chunk number 27: pool-score
###################################################
#line 367 "imputation-vignette.Rnw"
both <- pool(obs, imp, score=TRUE)
class(both)


###################################################
### chunk number 28: sign
###################################################
#line 376 "imputation-vignette.Rnw"
table(effect.sign(obs))


###################################################
### chunk number 29: switch
###################################################
#line 400 "imputation-vignette.Rnw"
effect.sign(obs)[1:6]
sw.obs <- switch.alleles(obs, 1:3)
class(sw.obs)
effect.sign(sw.obs)[1:6]


