###################################################
### chunk number 1: lib
###################################################
#line 28 "data-input-vignette.Rnw"
require(snpStats)


###################################################
### chunk number 2: sysfile
###################################################
#line 98 "data-input-vignette.Rnw"
pedfile <- system.file("extdata/sample.ped.gz", package="snpStats")
pedfile
infofile <- system.file("extdata/sample.info", package="snpStats")


###################################################
### chunk number 3: redpedfile
###################################################
#line 104 "data-input-vignette.Rnw"
sample <- read.pedfile(pedfile, snps=infofile)


###################################################
### chunk number 4: sample1
###################################################
#line 110 "data-input-vignette.Rnw"
sample$genotypes
col.summary(sample$genotypes)$MAF
head(col.summary(sample$genotypes))


###################################################
### chunk number 5: sample2
###################################################
#line 117 "data-input-vignette.Rnw"
head(sample$fam)


###################################################
### chunk number 6: sample3
###################################################
#line 129 "data-input-vignette.Rnw"
head(sample$map)


###################################################
### chunk number 7: plink
###################################################
#line 149 "data-input-vignette.Rnw"
fam <- system.file("extdata/sample.fam", package="snpStats")
bim <- system.file("extdata/sample.bim", package="snpStats")
bed <- system.file("extdata/sample.bed", package="snpStats")
sample <- read.plink(bed, bim, fam)


###################################################
### chunk number 8: plinkout
###################################################
#line 157 "data-input-vignette.Rnw"
sample$genotypes
col.summary(sample$genotypes)$MAF
head(sample$fam)
head(sample$map)


###################################################
### chunk number 9: plinkselect
###################################################
#line 170 "data-input-vignette.Rnw"
subset <- read.plink(bed, bim, fam, select.snps=6:10)
subset$genotypes
col.summary(subset$genotypes)$MAF
subset$map


###################################################
### chunk number 10: longfile
###################################################
#line 187 "data-input-vignette.Rnw"
longfile <- system.file("extdata/sample-long.gz", package="snpStats")
longfile


###################################################
### chunk number 11: ssid
###################################################
#line 206 "data-input-vignette.Rnw"
samples <- paste("subject", 1:100, sep="")
snps <- paste("snp", 1:18, sep="")


###################################################
### chunk number 12: readlong
###################################################
#line 212 "data-input-vignette.Rnw"
gdata <- read.snps.long(longfile, sample.id=samples, snp.id=snps,
   fields=c(snp=1, sample=2, genotype=3, confidence=4),
   codes=c("1", "2", "3"), sep="\t",
   threshold=0.95)
gdata
summary(gdata)


