###################################################
### chunk number 1: 1
###################################################
#line 54 "snapCGHguide.Rnw"
library(snapCGH)


###################################################
### chunk number 2: 2
###################################################
#line 68 "snapCGHguide.Rnw"
datadir <- system.file("testdata", package="snapCGH")
targets <- readTargets("targets.txt", path=datadir)
RG1 <- read.maimages(targets$FileName, path=datadir, source = "genepix")


###################################################
### chunk number 3: 3
###################################################
#line 104 "snapCGHguide.Rnw"
RG1 <- read.clonesinfo("cloneinfo.txt", RG1, path=datadir)
RG1$printer <- getLayout(RG1$genes)
types <- readSpotTypes("SpotTypes.txt", path=datadir)
RG1$genes$Status <- controlStatus(types, RG1)



###################################################
### chunk number 4: 3a
###################################################
#line 119 "snapCGHguide.Rnw"
RG1$design <- c(-1,-1)


###################################################
### chunk number 5: 4
###################################################
#line 130 "snapCGHguide.Rnw"
RG2 <- backgroundCorrect(RG1, method="minimum")


###################################################
### chunk number 6: 5
###################################################
#line 145 "snapCGHguide.Rnw"
MA <- normalizeWithinArrays(RG2, method="median")


###################################################
### chunk number 7: 6
###################################################
#line 163 "snapCGHguide.Rnw"
MA2 <- processCGH(MA,method.of.averaging=mean, ID = "ID")


###################################################
### chunk number 8: segmentation1
###################################################
#line 173 "snapCGHguide.Rnw"
SegInfo.Hom <- runHomHMM(MA2, criteria = "AIC")


###################################################
### chunk number 9: segmentation2 eval=FALSE
###################################################
## #line 182 "snapCGHguide.Rnw"
## SegInfo.GLAD <- runGLAD(MA2)
## SegInfo.DNAcopy <- runDNAcopy(MA2)
## SegInfo.TilingArray <- runTilingArray(MA2)


###################################################
### chunk number 10: segmentation3 eval=FALSE
###################################################
## #line 193 "snapCGHguide.Rnw"
## SegInfo.Bio <- runBioHMM(MA2)


###################################################
### chunk number 11: segmentation4
###################################################
#line 204 "snapCGHguide.Rnw"
SegInfo.Hom.merged <- mergeStates(SegInfo.Hom, MergeType = 1)


###################################################
### chunk number 12: plotting1
###################################################
#line 223 "snapCGHguide.Rnw"
genomePlot(MA2, array = 1)                                               


###################################################
### chunk number 13: plotting2
###################################################
#line 230 "snapCGHguide.Rnw"
#line 223 "snapCGHguide.Rnw"
genomePlot(MA2, array = 1)                                               
#line 231 "snapCGHguide.Rnw"


###################################################
### chunk number 14: plotting3
###################################################
#line 245 "snapCGHguide.Rnw"
genomePlot(MA2, array = 1, chrom.to.plot = 8)


###################################################
### chunk number 15: plotting4
###################################################
#line 252 "snapCGHguide.Rnw"
#line 245 "snapCGHguide.Rnw"
genomePlot(MA2, array = 1, chrom.to.plot = 8)
#line 253 "snapCGHguide.Rnw"


###################################################
### chunk number 16: 14
###################################################
#line 288 "snapCGHguide.Rnw"
plotSegmentedGenome(SegInfo.Hom.merged, array = 1)


###################################################
### chunk number 17: 14a
###################################################
#line 294 "snapCGHguide.Rnw"
#line 288 "snapCGHguide.Rnw"
plotSegmentedGenome(SegInfo.Hom.merged, array = 1)
#line 295 "snapCGHguide.Rnw"


###################################################
### chunk number 18: 15
###################################################
#line 310 "snapCGHguide.Rnw"
Seg.DNAcopy <- runDNAcopy(MA2)
SegInfo.DNAcopy.merged <- mergeStates(Seg.DNAcopy)
plotSegmentedGenome(SegInfo.DNAcopy.merged, SegInfo.Hom.merged, array = 1,
                    chrom.to.plot = 1, colors = c("blue", "green"))


###################################################
### chunk number 19: 15a
###################################################
#line 319 "snapCGHguide.Rnw"
#line 310 "snapCGHguide.Rnw"
Seg.DNAcopy <- runDNAcopy(MA2)
SegInfo.DNAcopy.merged <- mergeStates(Seg.DNAcopy)
plotSegmentedGenome(SegInfo.DNAcopy.merged, SegInfo.Hom.merged, array = 1,
                    chrom.to.plot = 1, colors = c("blue", "green"))
#line 320 "snapCGHguide.Rnw"


###################################################
### chunk number 20: iplotting1 eval=FALSE
###################################################
## #line 340 "snapCGHguide.Rnw"
## zoomGenome(SegInfo.Hom.merged, array = 1)


###################################################
### chunk number 21: iplotting2 eval=FALSE
###################################################
## #line 359 "snapCGHguide.Rnw"
## zoomChromosome(SegInfo.Hom.merged, array = 1, chrom.to.plot = 8)


###################################################
### chunk number 22: Simulation1
###################################################
#line 383 "snapCGHguide.Rnw"
simulation <- simulateData(nArrays = 4)


###################################################
### chunk number 23: Simulation2
###################################################
#line 396 "snapCGHguide.Rnw"
Sim.HomHMM <- runHomHMM(simulation)
Sim.DNAcopy <- runDNAcopy(simulation)
rates <- compareSegmentations(simulation, offset = 0, Sim.HomHMM, Sim.DNAcopy)


###################################################
### chunk number 24: Simulation3
###################################################
#line 410 "snapCGHguide.Rnw"
rates


###################################################
### chunk number 25: Simulation4
###################################################
#line 418 "snapCGHguide.Rnw"
par(mfrow = c(1,2))
boxplot(rates$TPR ~ row(rates$TPR), col = c("red", "blue"), main = "True Positive Rate")
boxplot(rates$FDR ~ row(rates$FDR), col = c("red", "blue"), main = "False Discovery Rate")


