###################################################
### chunk number 1: 
###################################################
#line 26 "segmentSeq.Rnw"
  library(segmentSeq)


###################################################
### chunk number 2:  eval=FALSE
###################################################
## #line 32 "segmentSeq.Rnw"
##   library(snow)
## cl <- makeCluster(7, "MPI")


###################################################
### chunk number 3: 
###################################################
#line 38 "segmentSeq.Rnw"
  cl <- NULL


###################################################
### chunk number 4: 
###################################################
#line 44 "segmentSeq.Rnw"
chrlens <- c(1e6, 5e5)

datadir <- system.file("extdata", package = "segmentSeq")
libfiles <- c("SL9.txt", "SL10.txt", "SL26.txt", "SL32.txt")
libnames <- c("SL9", "SL10", "SL26", "SL32")
replicates <- c(1,1,2,2)

aD <- processTags(libfiles, dir = datadir, replicates, libnames, chrlens, chrs = c(">Chr1", ">Chr2"), header = TRUE, gap = 200)
aD


###################################################
### chunk number 5: 
###################################################
#line 58 "segmentSeq.Rnw"
sD <- processAD(aD, cl = cl)

sD


###################################################
### chunk number 6: 
###################################################
#line 70 "segmentSeq.Rnw"
clustSegs <- heuristicSeg(sD = sD, aD = aD, bimodality = TRUE, getLikes = TRUE, cl = cl)
clustSegs


###################################################
### chunk number 7: 
###################################################
#line 84 "segmentSeq.Rnw"
classSegs <- classifySeg(sD = sD, aD = aD, cD = clustSegs, subRegion = NULL, getLikes = TRUE, cl = cl, lociCutoff = 0.9, nullCutoff = 0.9)
classSegs


###################################################
### chunk number 8: segPlot
###################################################
#line 94 "segmentSeq.Rnw"
  par(mfrow = c(2,1), mar = c(2,2,2,2))
plotGenome(aD, clustSegs, chr = ">Chr1", limits = c(1, 3e5))
plotGenome(aD, classSegs, chr = ">Chr1", limits = c(1, 3e5))


###################################################
### chunk number 9: figSeg
###################################################
#line 103 "segmentSeq.Rnw"
#line 94 "segmentSeq.Rnw"
  par(mfrow = c(2,1), mar = c(2,2,2,2))
plotGenome(aD, clustSegs, chr = ">Chr1", limits = c(1, 3e5))
plotGenome(aD, classSegs, chr = ">Chr1", limits = c(1, 3e5))
#line 104 "segmentSeq.Rnw"


