/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.model;

import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.model.DLPredicate;
import org.semanticweb.HermiT.model.DescriptionGraph;
import org.semanticweb.HermiT.model.ExistentialConcept;
import org.semanticweb.HermiT.model.InterningManager;

public class ExistsDescriptionGraph
extends ExistentialConcept
implements DLPredicate {
    private static final long serialVersionUID = 7433430510725260994L;
    protected final DescriptionGraph m_descriptionGraph;
    protected final int m_vertex;
    protected static InterningManager<ExistsDescriptionGraph> s_interningManager = new InterningManager<ExistsDescriptionGraph>(){

        @Override
        protected boolean equal(ExistsDescriptionGraph existsDescriptionGraph, ExistsDescriptionGraph existsDescriptionGraph2) {
            return existsDescriptionGraph.m_descriptionGraph.equals(existsDescriptionGraph2.m_descriptionGraph) && existsDescriptionGraph.m_vertex == existsDescriptionGraph2.m_vertex;
        }

        @Override
        protected int getHashCode(ExistsDescriptionGraph existsDescriptionGraph) {
            return existsDescriptionGraph.m_descriptionGraph.hashCode() + 7 * existsDescriptionGraph.m_vertex;
        }
    };

    protected ExistsDescriptionGraph(DescriptionGraph descriptionGraph, int n) {
        this.m_descriptionGraph = descriptionGraph;
        this.m_vertex = n;
    }

    public DescriptionGraph getDescriptionGraph() {
        return this.m_descriptionGraph;
    }

    public int getVertex() {
        return this.m_vertex;
    }

    public int getArity() {
        return 1;
    }

    public boolean isAlwaysTrue() {
        return false;
    }

    public boolean isAlwaysFalse() {
        return false;
    }

    public String toString(Prefixes prefixes) {
        return "exists(" + prefixes.abbreviateIRI(this.m_descriptionGraph.getName()) + '|' + this.m_vertex + ')';
    }

    public String toString() {
        return this.toString(Prefixes.STANDARD_PREFIXES);
    }

    protected Object readResolve() {
        return s_interningManager.intern(this);
    }

    public static ExistsDescriptionGraph create(DescriptionGraph descriptionGraph, int n) {
        return s_interningManager.intern(new ExistsDescriptionGraph(descriptionGraph, n));
    }
}

