/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.model;

import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.model.AtomicDataRange;
import org.semanticweb.HermiT.model.AtomicNegationDataRange;
import org.semanticweb.HermiT.model.Constant;
import org.semanticweb.HermiT.model.InterningManager;
import org.semanticweb.HermiT.model.LiteralDataRange;

public class ConstantEnumeration
extends AtomicDataRange {
    private static final long serialVersionUID = 4663162424764302912L;
    protected final Constant[] m_constants;
    protected static InterningManager<ConstantEnumeration> s_interningManager = new InterningManager<ConstantEnumeration>(){

        @Override
        protected boolean equal(ConstantEnumeration constantEnumeration, ConstantEnumeration constantEnumeration2) {
            if (constantEnumeration.m_constants.length != constantEnumeration2.m_constants.length) {
                return false;
            }
            for (int i = constantEnumeration.m_constants.length - 1; i >= 0; --i) {
                if (this.contains(constantEnumeration.m_constants[i], constantEnumeration2.m_constants)) continue;
                return false;
            }
            return true;
        }

        protected boolean contains(Constant constant, Constant[] constantArray) {
            for (int i = constantArray.length - 1; i >= 0; --i) {
                if (!constantArray[i].equals(constant)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected int getHashCode(ConstantEnumeration constantEnumeration) {
            int n = 0;
            for (int i = constantEnumeration.m_constants.length - 1; i >= 0; --i) {
                n += constantEnumeration.m_constants[i].hashCode();
            }
            return n;
        }
    };

    protected ConstantEnumeration(Constant[] constantArray) {
        this.m_constants = constantArray;
    }

    public int getNumberOfConstants() {
        return this.m_constants.length;
    }

    public Constant getConstant(int n) {
        return this.m_constants[n];
    }

    public LiteralDataRange getNegation() {
        return AtomicNegationDataRange.create(this);
    }

    public boolean isAlwaysTrue() {
        return false;
    }

    public boolean isAlwaysFalse() {
        return this.m_constants.length == 0;
    }

    public String toString(Prefixes prefixes) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ ");
        for (int i = 0; i < this.m_constants.length; ++i) {
            if (i > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(this.m_constants[i].toString(prefixes));
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    protected Object readResolve() {
        return s_interningManager.intern(this);
    }

    public static ConstantEnumeration create(Constant[] constantArray) {
        return s_interningManager.intern(new ConstantEnumeration(constantArray));
    }
}

