/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datatypes.owlreal;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.semanticweb.HermiT.datatypes.owlreal.BigRational;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum NumberRange {
    NOTHING,
    INTEGER,
    DECIMAL,
    RATIONAL,
    REAL;


    public boolean isDense() {
        return this.ordinal() >= DECIMAL.ordinal();
    }

    public static NumberRange intersection(NumberRange numberRange, NumberRange numberRange2) {
        int n = Math.min(numberRange.ordinal(), numberRange2.ordinal());
        return NumberRange.values()[n];
    }

    public static NumberRange union(NumberRange numberRange, NumberRange numberRange2) {
        int n = Math.max(numberRange.ordinal(), numberRange2.ordinal());
        return NumberRange.values()[n];
    }

    public static boolean isSubsetOf(NumberRange numberRange, NumberRange numberRange2) {
        return numberRange.ordinal() <= numberRange2.ordinal();
    }

    public static NumberRange getMostSpecificRange(Number number) {
        if (number instanceof Integer || number instanceof Long || number instanceof BigInteger) {
            return INTEGER;
        }
        if (number instanceof BigDecimal) {
            return DECIMAL;
        }
        if (number instanceof BigRational) {
            return RATIONAL;
        }
        throw new IllegalArgumentException();
    }
}

