###################################################
### chunk number 1: preliminaries
###################################################
#line 57 "mosaics-example.Rnw"
options(prompt = "R> ")


###################################################
### chunk number 2: mosaics-prelim
###################################################
#line 61 "mosaics-example.Rnw"
library("mosaics")


###################################################
### chunk number 3: mosaicsExample-prelim
###################################################
#line 102 "mosaics-example.Rnw"
library(mosaicsExample)


###################################################
### chunk number 4: ts-readbin
###################################################
#line 108 "mosaics-example.Rnw"
exampleBinData <- readBins( type=c("chip","input","M","GC","N"),
    fileName=c( system.file( file.path("extdata","chip_chr21.txt"), package="mosaicsExample"),
    system.file( file.path("extdata","input_chr21.txt"), package="mosaicsExample"),
    system.file( file.path("extdata","M_chr21.txt"), package="mosaicsExample"),
    system.file( file.path("extdata","GC_chr21.txt"), package="mosaicsExample"),
    system.file( file.path("extdata","N_chr21.txt"), package="mosaicsExample") ) )


###################################################
### chunk number 5: ts-bindata-show
###################################################
#line 132 "mosaics-example.Rnw"
exampleBinData


###################################################
### chunk number 6: ts-bindata-print
###################################################
#line 138 "mosaics-example.Rnw"
print(exampleBinData)[51680:51690,]


###################################################
### chunk number 7: ts-bindata-plot eval=FALSE
###################################################
## #line 153 "mosaics-example.Rnw"
## plot(exampleBinData)
## plot( exampleBinData, plotType="M" )
## plot( exampleBinData, plotType="GC" )
## plot( exampleBinData, plotType="input" )
## plot( exampleBinData, plotType="M|input" )
## plot( exampleBinData, plotType="GC|input" )  


###################################################
### chunk number 8: fig-bindata-plot-hist
###################################################
#line 181 "mosaics-example.Rnw"
plot(exampleBinData)


###################################################
### chunk number 9: fig-bindata-plot-M
###################################################
#line 191 "mosaics-example.Rnw"
plot( exampleBinData, plotType="M" )


###################################################
### chunk number 10: fig-bindata-plot-GC
###################################################
#line 200 "mosaics-example.Rnw"
plot( exampleBinData, plotType="GC" )


###################################################
### chunk number 11: fig-bindata-plot-input
###################################################
#line 209 "mosaics-example.Rnw"
plot( exampleBinData, plotType="input" )


###################################################
### chunk number 12: fig-bindata-plot-M-input
###################################################
#line 219 "mosaics-example.Rnw"
plot( exampleBinData, plotType="M|input" )


###################################################
### chunk number 13: fig-bindata-plot-GC-input
###################################################
#line 229 "mosaics-example.Rnw"
plot( exampleBinData, plotType="GC|input" )


###################################################
### chunk number 14: ts-mosaicsfit eval=FALSE
###################################################
## #line 242 "mosaics-example.Rnw"
## exampleFit <- mosaicsFit( exampleBinData, analysisType="TS" )


###################################################
### chunk number 15: ts-mosaicsfit-load-fit
###################################################
#line 246 "mosaics-example.Rnw"
data(exampleFit)


###################################################
### chunk number 16: ts-mosaicsfit-show
###################################################
#line 266 "mosaics-example.Rnw"
exampleFit


###################################################
### chunk number 17: ts-mosaicsfit-plot eval=FALSE
###################################################
## #line 278 "mosaics-example.Rnw"
## plot(exampleFit)


###################################################
### chunk number 18: fig-mosaicsfit-plot
###################################################
#line 284 "mosaics-example.Rnw"
plot(exampleFit)


###################################################
### chunk number 19: ts-mosaicspeak
###################################################
#line 313 "mosaics-example.Rnw"
examplePeak <- mosaicsPeak( exampleFit, signalModel="2S", FDR=0.05, 
maxgap=200, minsize=50, thres=10 )


###################################################
### chunk number 20: ts-mosaicspeak-show
###################################################
#line 348 "mosaics-example.Rnw"
examplePeak


###################################################
### chunk number 21: ts-mosaicspeak-print
###################################################
#line 366 "mosaics-example.Rnw"
print(examplePeak)[1:15,]


###################################################
### chunk number 22: ts-mosaicspeak-export
###################################################
#line 379 "mosaics-example.Rnw"
export( examplePeak, type="txt", fileLoc=".",
 fileName="TSpeakList.txt", chrID="chr21" )
export( examplePeak, type="bed", fileLoc=".",
 fileName="TSpeakList.bed", chrID="chr21" )
export( examplePeak, type="gff", fileLoc=".", 
 fileName="TSpeakList.gff", chrID="chr21" )


###################################################
### chunk number 23: os-readbin
###################################################
#line 402 "mosaics-example.Rnw"
OneSampleBinData <- readBins( type=c("chip","M","GC","N"),
    fileName=c( system.file( file.path("extdata","chip_chr21.txt"), package="mosaicsExample"),
    system.file( file.path("extdata","M_chr21.txt"), package="mosaicsExample"),
    system.file( file.path("extdata","GC_chr21.txt"), package="mosaicsExample"),
    system.file( file.path("extdata","N_chr21.txt"), package="mosaicsExample") ) )


###################################################
### chunk number 24: os-mosaicsfit eval=FALSE
###################################################
## #line 416 "mosaics-example.Rnw"
## OneSampleFit <- mosaicsFit( OneSampleBinData, analysisType="OS" )


###################################################
### chunk number 25: os-mosaicspeak eval=FALSE
###################################################
## #line 423 "mosaics-example.Rnw"
## OneSamplePeak <- mosaicsPeak( OneSampleFit, signalModel="2S", FDR=0.05,
## maxgap=200, minsize=50, thres=10 )


###################################################
### chunk number 26: io-mosaicsfit eval=FALSE
###################################################
## #line 437 "mosaics-example.Rnw"
## inputOnlyFit <- mosaicsFit( exampleBinData, analysisType="IO" )


###################################################
### chunk number 27: io-readbin
###################################################
#line 445 "mosaics-example.Rnw"
inputOnlyBinData <- readBins( type=c("chip","input"),
    fileName=c( system.file( file.path("extdata","chip_chr21.txt"), package="mosaicsExample"),
    system.file( file.path("extdata","input_chr21.txt"), package="mosaicsExample") ) )


###################################################
### chunk number 28: io-mosaicsfit-io-readbin eval=FALSE
###################################################
## #line 450 "mosaics-example.Rnw"
## inputOnlyFit <- mosaicsFit( inputOnlyBinData, analysisType="IO" )


###################################################
### chunk number 29: tuning-ts eval=FALSE
###################################################
## #line 465 "mosaics-example.Rnw"
## exampleFit <- mosaicsFit( exampleBinData, analysisType="TS", 
## meanThres=1, s=2, d=0.25 )


