###################################################
### chunk number 1: 
###################################################
#line 23 "methVisual.Rnw"
library(methVisual)
library(Biostrings)
library(gridBase) 
library(ca)
library(sqldf)
library(plotrix)
ps.options(pointsize=12)
options(width=60)


###################################################
### chunk number 2: 
###################################################
#line 92 "methVisual.Rnw"
library(methVisual)  


###################################################
### chunk number 3: 
###################################################
#line 103 "methVisual.Rnw"
dir.create(file.path(R.home(component="home"),"/BiqAnalyzer/"))


###################################################
### chunk number 4: 
###################################################
#line 107 "methVisual.Rnw"
makeLocalExpDir(dataPath="/examples/BiqAnalyzer",localDir=file.path(R.home(component="home"),"/BiqAnalyzer/"))


###################################################
### chunk number 5: 
###################################################
#line 112 "methVisual.Rnw"
methData <-MethDataInput(file.path(R.home(component="home"),"/BiqAnalyzer","/PathFileTab.txt"))


###################################################
### chunk number 6: 
###################################################
#line 117 "methVisual.Rnw"
methData


###################################################
### chunk number 7: 
###################################################
#line 122 "methVisual.Rnw"
refseq <- selectRefSeq(file.path(R.home(component="home"),"/BiqAnalyzer","/Master_Sequence.txt"))


###################################################
### chunk number 8: 
###################################################
#line 133 "methVisual.Rnw"
QCdata <- MethylQC(refseq, methData,makeChange=TRUE,identity=80,conversion=90)


###################################################
### chunk number 9: 
###################################################
#line 139 "methVisual.Rnw"
QCdata


###################################################
### chunk number 10: 
###################################################
#line 147 "methVisual.Rnw"
methData <- MethAlignNW( refseq , QCdata)
methData


###################################################
### chunk number 11:  eval=FALSE
###################################################
## #line 159 "methVisual.Rnw"
## plotAbsMethyl(methData,real=TRUE)
## 


###################################################
### chunk number 12: Absolute-Methylation-Plot
###################################################
#line 162 "methVisual.Rnw"
plotAbsMethyl(methData,real=TRUE)


###################################################
### chunk number 13:  eval=FALSE
###################################################
## #line 186 "methVisual.Rnw"
## MethLollipops(methData)
## 


###################################################
### chunk number 14: Lollipops-plot
###################################################
#line 189 "methVisual.Rnw"
MethLollipops(methData)


###################################################
### chunk number 15:  eval=FALSE
###################################################
## #line 212 "methVisual.Rnw"
## file <- file.path(R.home(component="home"),"/BiqAnalyzer/","Cooccurrence.pdf")
## Cooccurrence(methData,file=file)


###################################################
### chunk number 16:  eval=FALSE
###################################################
## #line 220 "methVisual.Rnw"
## 
## summery <- matrixSNP(methData)
## plotMatrixSNP(summery,methData)
## 


###################################################
### chunk number 17: Distant-cooccurrence
###################################################
#line 225 "methVisual.Rnw"
summery <- matrixSNP(methData)
plotMatrixSNP(summery,methData)


###################################################
### chunk number 18:  eval=FALSE
###################################################
## #line 250 "methVisual.Rnw"
## 
## methFisherTest(methData, c(2,3,5), c(1,4,6))
## 


###################################################
### chunk number 19: Fisher-Test
###################################################
#line 254 "methVisual.Rnw"
methFisherTest(methData, c(2,3,5), c(1,4,6))


###################################################
### chunk number 20: 
###################################################
#line 275 "methVisual.Rnw"
methWhitneyUTest(methData, c(2,3,5), c(1,4,6))


###################################################
### chunk number 21:  eval=FALSE
###################################################
## #line 282 "methVisual.Rnw"
## 
## heatMapMeth(methData)
## 


###################################################
### chunk number 22: Heat-Map
###################################################
#line 286 "methVisual.Rnw"
heatMapMeth(methData)


###################################################
### chunk number 23:  eval=FALSE
###################################################
## #line 307 "methVisual.Rnw"
## 
## methCA(methData)
## 


###################################################
### chunk number 24: CA
###################################################
#line 311 "methVisual.Rnw"
methCA(methData)


