###################################################
### chunk number 1: setup
###################################################
#line 54 "introduction.rnw"
library(ade4)
library(made4)
library(scatterplot3d)
oldopt <- options(digits=3)
options(width=60)
on.exit( {options(oldopt)} )


###################################################
### chunk number 2: loadlibs
###################################################
#line 120 "introduction.rnw"
 library(made4)
 library(ade4)


###################################################
### chunk number 3: loadkhan
###################################################
#line 125 "introduction.rnw"
 data(khan)


###################################################
### chunk number 4: khandata
###################################################
#line 131 "introduction.rnw"
names(khan)
k.data<-khan$train
k.class<-khan$train.classes


###################################################
### chunk number 5: overview.extra
###################################################
#line 146 "introduction.rnw"
overview(k.data)


###################################################
### chunk number 6: overviewKhan
###################################################
#line 156 "introduction.rnw"
overview(k.data, labels=k.class)


###################################################
### chunk number 7: overviewKhan2
###################################################
#line 169 "introduction.rnw"
overview(k.data, classvec=k.class, labels=k.class)


###################################################
### chunk number 8: ord.coa
###################################################
#line 184 "introduction.rnw"
k.coa<- ord(k.data, type="coa")


###################################################
### chunk number 9: output.coa
###################################################
#line 191 "introduction.rnw"
names(k.coa)
summary(k.coa$ord)


###################################################
### chunk number 10: see.classes
###################################################
#line 204 "introduction.rnw"
k.class


###################################################
### chunk number 11: plotcoa
###################################################
#line 212 "introduction.rnw"
plot(k.coa, classvec=k.class, arraycol=c("red", "blue", "yellow", "green"), genecol="grey3")


###################################################
### chunk number 12: plotarrays
###################################################
#line 228 "introduction.rnw"
plotgenes(k.coa)  


###################################################
### chunk number 13: plotarrays
###################################################
#line 233 "introduction.rnw"
plotarrays(k.coa, arraylabels=k.class)


###################################################
### chunk number 14: plotarays2
###################################################
#line 239 "introduction.rnw"
k.coa2<-ord(k.data, classvec=k.class)
plot(k.coa2)


###################################################
### chunk number 15: plotgenes
###################################################
#line 251 "introduction.rnw"
plotgenes(k.coa, n=5, col="red")


###################################################
### chunk number 16: plotgenescmd
###################################################
#line 262 "introduction.rnw"

gene.symbs<- khan$annotation$Symbol 
plotgenes(k.coa, n=10, col="red", genelabels=gene.symbs)


###################################################
### chunk number 17: plotgenes2
###################################################
#line 271 "introduction.rnw"
plotgenes(k.coa, n=10, col="red", genelabels=gene.symbs)


###################################################
### chunk number 18: topgenes
###################################################
#line 280 "introduction.rnw"
topgenes(k.coa, axis = 1, n=5)   


###################################################
### chunk number 19: topgenes2
###################################################
#line 285 "introduction.rnw"
topgenes(k.coa, labels=gene.symbs, end="neg") 


###################################################
### chunk number 20: do3d
###################################################
#line 297 "introduction.rnw"
do3d(k.coa$ord$co, classvec=k.class, cex.symbols=3)
html3D(k.coa$ord$co, k.class, writehtml=TRUE)


###################################################
### chunk number 21: bga
###################################################
#line 328 "introduction.rnw"
k.bga<-bga(k.data, type="coa", classvec=k.class)


###################################################
### chunk number 22: BGAplot
###################################################
#line 335 "introduction.rnw"
plot(k.bga, genelabels=gene.symbs) # Use the gene symbols earlier


###################################################
### chunk number 23: between.graph
###################################################
#line 345 "introduction.rnw"
between.graph(k.bga, ax=1)  # Show the separation on the first axes(ax)


###################################################
### chunk number 24: CIA
###################################################
#line 361 "introduction.rnw"
# Example data are "G1_Ross_1375.txt" and "G5_Affy_1517.txt"
data(NCI60)
coin <- cia(NCI60$Ross, NCI60$Affy)
names(coin)
coin$coinertia$RV


###################################################
### chunk number 25: CIAplot
###################################################
#line 375 "introduction.rnw"
plot(coin, classvec=NCI60$classes[,2], clab=0, cpoint=3)


