###################################################
### chunk number 1: 
###################################################
#line 77 "hyperdraw.Rnw"
library(hyperdraw)



###################################################
### chunk number 2: 
###################################################
#line 84 "hyperdraw.Rnw"
nodes <- c(LETTERS[1:5], paste("R", 1:3, sep=""))
testgnel <- new("graphNEL",
                nodes=nodes,
                edgeL=list(
                  A=list(edges=c("R1", "R2")),
                  B=list(edges="R2"),
                  C=list(),
                  D=list(edges="R3"),
                  E=list(),
                  R1=list(edges="B"),
                  R2=list(edges=c("C", "D")),
                  R3=list(edges="E")),
                edgemode="directed")



###################################################
### chunk number 3: gnel
###################################################
#line 104 "hyperdraw.Rnw"
plot(testgnel)



###################################################
### chunk number 4: 
###################################################
#line 119 "hyperdraw.Rnw"
testbph <- graphBPH(testgnel, edgeNodePattern="^R")



###################################################
### chunk number 5: 
###################################################
#line 138 "hyperdraw.Rnw"
dh1 <- DirectedHyperedge("A", "B", "R1")
dh2 <- DirectedHyperedge(c("A", "B"), c("C", "D"), "R2")
dh3 <- DirectedHyperedge("D", "E", "R3")
hg <- Hypergraph(LETTERS[1:5], list(dh1, dh2, dh3))
hgbph <- graphBPH(hg)



###################################################
### chunk number 6: bph
###################################################
#line 152 "hyperdraw.Rnw"
plot(testbph)



###################################################
### chunk number 7: 
###################################################
#line 165 "hyperdraw.Rnw"
testrabph <- graphLayout(testbph)



###################################################
### chunk number 8: rabph
###################################################
#line 176 "hyperdraw.Rnw"
edgeDataDefaults(testrabph, "lwd") <- 1
edgeData(testrabph, c("A", "R1"), 
                    c("R1", "B"), "lwd") <- c("5", "3")
edgeDataDefaults(testrabph, "color") <- "black"
edgeData(testrabph, c("A", "R1"), 
                    c("R1", "B"), "color") <- "red"
nodeDataDefaults(testrabph, "margin") <- 'unit(3, "mm")'
nodeDataDefaults(testrabph, "shape") <- "box"
plot(testrabph)




