###################################################
### chunk number 1: setup
###################################################
#line 22 "genome-tables.Rnw"
library(genomes)
options(warn=-1, width=75, digits=2, scipen=3,  "prompt" = "R> ", "continue" = " ")
options(SweaveHooks=list(fig=function() par(mar=c(5,4.2,1,1))))


###################################################
### chunk number 2: biocLite eval=FALSE
###################################################
## #line 48 "genome-tables.Rnw"
## source("http://bioconductor.org/biocLite.R")
## biocLite("genomes")


###################################################
### chunk number 3: install eval=FALSE
###################################################
## #line 57 "genome-tables.Rnw"
## install.packages("genomes", 
##    repos="http://www.bioconductor.org/packages/devel/bioC")


###################################################
### chunk number 4: lproks
###################################################
#line 75 "genome-tables.Rnw"
data(lproks)
lproks
summary(lproks)
plot(lproks, log='y', las=1)
data(leuks)
data(lenvs)
lines(leuks, col="red")
lines(lenvs, col="green3")
legend("topleft", c("Microbes", "Eukaryotes", "Metagenomes"),
         lty=1,  bty='n', col=c("blue", "red", "green3"))


###################################################
### chunk number 5: update eval=FALSE
###################################################
## #line 101 "genome-tables.Rnw"
## update(lproks)


###################################################
### chunk number 6: table2
###################################################
#line 111 "genome-tables.Rnw"
spp<-species(lproks$name)
table2(spp)


###################################################
### chunk number 7: complete
###################################################
#line 120 "genome-tables.Rnw"
complete <- subset(lproks, status == "Complete")
x<-table(year(complete$released))
barplot(x, col="blue", ylim=c(0,max(x)*1.04), space=0.5, las=1,
axis.lty=1, xlab="Year", ylab="Genomes per year")
box()


###################################################
### chunk number 8: yersinia
###################################################
#line 143 "genome-tables.Rnw"
## Yersinia pestis
yp<-subset(lproks, name %like% 'Yersinia pestis*')
plotby(yp, labels=TRUE, cex=.5, lbty='n')



