###################################################
### chunk number 1: libraries
###################################################
#line 40 "flagme.Rnw"
require(gcspikelite)
library(flagme)


###################################################
### chunk number 2: rawdata
###################################################
#line 48 "flagme.Rnw"
gcmsPath<-paste(.find.package("gcspikelite"),"data",sep="/")
data(targets)
cdfFiles<-paste(gcmsPath,targets$FileName,sep="/")
eluFiles<-gsub("CDF","ELU",cdfFiles)
pd<-peaksDataset(cdfFiles,mz=seq(50,550),rtrange=c(7.5,8.5))
pd<-addAMDISPeaks(pd,eluFiles)
pd


###################################################
### chunk number 3: plotexample1
###################################################
#line 64 "flagme.Rnw"
plot(pd,rtrange=c(7.5,8.5),plotPeaks=TRUE,plotPeakLabels=TRUE,max.near=8,how.near=.5,col=rep(c("blue","red","black"),each=3))


###################################################
### chunk number 4: plotexample2
###################################################
#line 76 "flagme.Rnw"
r<-1
plotImage(pd,run=r,rtrange=c(7.5,8.5),main="")
v<-which(pd@peaksdata[[r]]>0,arr.ind=TRUE) # find detected peaks
abline(v=pd@peaksrt[[r]])
points(pd@peaksrt[[r]][v[,2]],pd@mz[v[,1]],pch=19,cex=.6,col="white")


###################################################
### chunk number 5: pairwisealignexample
###################################################
#line 97 "flagme.Rnw"
Ds<-c(0.1,10,0.1,0.1)
gaps<-c(0.5,0.5,0.1,0.9)
par(mfrow=c(2,2),mai=c(0.8466,0.4806,0.4806,0.1486))
for(i in 1:4) {
  pa<-peaksAlignment(pd@peaksdata[[1]],pd@peaksdata[[2]],pd@peaksrt[[1]],pd@peaksrt[[2]],D=Ds[i],gap=gaps[i])
  plot(pa,xlim=c(0,17),ylim=c(0,16),matchCol="yellow",main=paste("D=",Ds[i]," gap=",gaps[i],sep=""))
}


###################################################
### chunk number 6: multiplealignment
###################################################
#line 125 "flagme.Rnw"
print(targets)
ma<-multipleAlignment(pd,group=targets$Group,wn.gap=0.5,wn.D=.05,bw.gap=.6,bw.D=0.05,usePeaks=TRUE,filterMin=2,df=50,verbose=FALSE)
ma


###################################################
### chunk number 7: multiplealignmentfig
###################################################
#line 133 "flagme.Rnw"
plot(pd,rtrange=c(7.5,8.5),runs=ma@betweenAlignment@runs,mind=ma@betweenAlignment@ind,plotPeaks=TRUE,plotPeakLabels=TRUE,max.near=8,how.near=.5,col=rep(c("blue","red","black"),each=3))


###################################################
### chunk number 8: multiplealignmentres
###################################################
#line 140 "flagme.Rnw"
ma@betweenAlignment@runs
ma@betweenAlignment@ind


###################################################
### chunk number 9: alignmentres
###################################################
#line 147 "flagme.Rnw"
outList<-gatherInfo(pd,ma)
outList[[8]]
rtmat<-matrix(unlist(lapply(outList,.subset,"rt"),use.names=FALSE),nr=length(outList),byrow=TRUE)
colnames(rtmat)<-names(outList[[1]]$rt); rownames(rtmat)<-1:nrow(rtmat)
round(rtmat,3)


###################################################
### chunk number 10: session
###################################################
#line 188 "flagme.Rnw"
sessionInfo()
date()


