###################################################
### chunk number 1: get-data
###################################################
#line 94 "pca-vignette.Rnw"
require(chopsticks)
data(for.exercise)
controls <- rownames(subject.support)[subject.support$cc==0]
use <- seq(1, ncol(snps.10), 10)
ctl.10 <- snps.10[controls,use]


###################################################
### chunk number 2: xxt-matrix
###################################################
#line 104 "pca-vignette.Rnw"
xxmat <- xxt(ctl.10, correct.for.missing=FALSE)


###################################################
### chunk number 3: eigen
###################################################
#line 126 "pca-vignette.Rnw"
evv <- eigen(xxmat, symmetric=TRUE)
pcs <- evv$vectors[,1:5]
evals <- evv$values[1:5]
evals


###################################################
### chunk number 4: pc-one
###################################################
#line 138 "pca-vignette.Rnw"
pop <- subject.support[controls,"stratum"]
par(mfrow=c(1,2))
boxplot(pcs[,1]~pop)
boxplot(pcs[,2]~pop)


###################################################
### chunk number 5: pre-multiply
###################################################
#line 153 "pca-vignette.Rnw"
btr <- snp.pre.multiply(ctl.10, diag(1/sqrt(evals)) %*% t(pcs))


###################################################
### chunk number 6: post-multiply
###################################################
#line 164 "pca-vignette.Rnw"
pcs <- snp.post.multiply(snps.10[,use], t(btr))


###################################################
### chunk number 7: testing
###################################################
#line 171 "pca-vignette.Rnw"
cc <- subject.support$cc
uncorrected <- single.snp.tests(cc, snp.data=snps.10)
corrected <- snp.rhs.tests(cc~pcs[,1], snp.data=snps.10)
par(mfrow=c(1,2),cex.sub=0.85)
qq.chisq(chi.squared(uncorrected,1), df=1)
qq.chisq(chi.squared(corrected), df=1)


