###################################################
### chunk number 1: init
###################################################
#line 58 "clustering-comparison-vignette.Rnw"
library(chopsticks)
load(system.file("data/Genotypes.GenTrain1.RData",package="chopsticks"))
load(system.file("data/Genotypes.GenTrain2.RData",package="chopsticks"))


###################################################
### chunk number 2: 
###################################################
#line 66 "clustering-comparison-vignette.Rnw"
ab.signals <- read.wtccc.signals(system.file("extdata/example-new.txt", package="chopsticks"),
                                 paste("rs", 1:99, sep=""))


###################################################
### chunk number 3: 
###################################################
#line 73 "clustering-comparison-vignette.Rnw"
col.summary(GenTrain2)[1:3,2:7]


###################################################
### chunk number 4: lothist
###################################################
#line 79 "clustering-comparison-vignette.Rnw"
result <- snp.compare(GenTrain1, GenTrain2)
diff.counts <- result$count
hist(diff.counts,breaks=50,col='black')


###################################################
### chunk number 5: 
###################################################
#line 94 "clustering-comparison-vignette.Rnw"
dim(GenTrain1)
diff.counts[diff.counts > 1550 * 0.1]
diff.counts[diff.counts > 1550 * 0.05]
worst.snps <- names(diff.counts[diff.counts > 1550 * 0.20])
worst.snps


###################################################
### chunk number 6: plot-clus1gtrs22
###################################################
#line 106 "clustering-comparison-vignette.Rnw"
par(mfrow=c(1,2),plt=c(0.25, 0.9, 0.15, 0.8),col.main="black",col.axis="black",cex=0.5,cex.main=1.7)
snp.clust.plot(ab.signals[['rs22']], GenTrain1[,'rs22'], title='rs22 GenTrain1')
snp.clust.plot(ab.signals[['rs22']], GenTrain2[,'rs22'], title='rs22 GenTrain2')


###################################################
### chunk number 7: plot-clus1gtrs27
###################################################
#line 117 "clustering-comparison-vignette.Rnw"
par(mfrow=c(1,2),plt=c(0.25, 0.9, 0.15, 0.8),col.main="black",col.axis="black",cex=0.5,cex.main=1.7)
snp.clust.plot(ab.signals[['rs27']], GenTrain1[,'rs27'], title='rs27 GenTrain1')
snp.clust.plot(ab.signals[['rs27']], GenTrain2[,'rs27'], title='rs27 GenTrain2')


###################################################
### chunk number 8: plot-clus1gtrs62
###################################################
#line 133 "clustering-comparison-vignette.Rnw"
par(mfrow=c(1,2),plt=c(0.25, 0.9, 0.15, 0.8),col.main="black",col.axis="black",cex=0.5,cex.main=1.7)
snp.clust.plot(ab.signals[['rs62']], GenTrain1[,'rs62'], title='rs62 GenTrain1')
snp.clust.plot(ab.signals[['rs62']], GenTrain2[,'rs62'], title='rs62 GenTrain2')


###################################################
### chunk number 9: plot-clus1gtrs80
###################################################
#line 141 "clustering-comparison-vignette.Rnw"
par(mfrow=c(1,2),plt=c(0.25, 0.9, 0.15, 0.8),col.main="black",col.axis="black",cex=0.5,cex.main=1.7)
snp.clust.plot(ab.signals[['rs80']], GenTrain1[,'rs80'], title='rs80 GenTrain1')
snp.clust.plot(ab.signals[['rs80']], GenTrain2[,'rs80'], title='rs80 GenTrain2')


###################################################
### chunk number 10: plot-clus1gtrs94
###################################################
#line 152 "clustering-comparison-vignette.Rnw"
par(mfrow=c(1,2),plt=c(0.25, 0.9, 0.15, 0.8),col.main="black",col.axis="black",cex=0.5,cex.main=1.7)
snp.clust.plot(ab.signals[['rs94']], GenTrain1[,'rs94'], title='rs94 GenTrain1')
snp.clust.plot(ab.signals[['rs94']], GenTrain2[,'rs94'], title='rs94 GenTrain2')


###################################################
### chunk number 11: lothist2
###################################################
#line 164 "clustering-comparison-vignette.Rnw"
count.signed <- result$count.signed
hist(count.signed,breaks=50,col='black')


###################################################
### chunk number 12: 
###################################################
#line 171 "clustering-comparison-vignette.Rnw"
result$count.signed[result$count.signed < -30]


###################################################
### chunk number 13: plot-clus1gtrs13
###################################################
#line 177 "clustering-comparison-vignette.Rnw"
par(mfrow=c(1,2),plt=c(0.25, 0.9, 0.15, 0.8),col.main="black",col.axis="black",cex=0.5,cex.main=1.7)
snp.clust.plot(ab.signals[['rs13']], GenTrain1[,'rs13'], title='rs13 GenTrain1')
snp.clust.plot(ab.signals[['rs13']], GenTrain2[,'rs13'], title='rs13 GenTrain2')


###################################################
### chunk number 14: plot-clus1gtrs69
###################################################
#line 183 "clustering-comparison-vignette.Rnw"
par(mfrow=c(1,2),plt=c(0.25, 0.9, 0.15, 0.8),col.main="black",col.axis="black",cex=0.5,cex.main=1.7)
snp.clust.plot(ab.signals[['rs69']], GenTrain1[,'rs69'], title='rs69 GenTrain1')
snp.clust.plot(ab.signals[['rs69']], GenTrain2[,'rs69'], title='rs69 GenTrain2')


###################################################
### chunk number 15: 
###################################################
#line 195 "clustering-comparison-vignette.Rnw"
col.summary(GenTrain1)[worst.snps,2:7]
col.summary(GenTrain2)[worst.snps,2:7]


