###################################################
### chunk number 1: setup
###################################################
#line 44 "Workflow.Rnw"

library(chipseq)
library(GenomicFeatures)
library(lattice)



###################################################
### chunk number 2: preprocess eval=FALSE
###################################################
## #line 72 "Workflow.Rnw"
## qa_list <- lapply(sampleFiles, qa)
## report(do.call(rbind, qa_list))
## ## spend some time evaluating the QA report, then procede
## filter <- compose(chipseqFilter(), alignQualityFilter(15))
## cstest <- seqapply(sampleFiles, function(file) {
##   as(readAligned(file, filter), "GRanges")
## })
## cstest <- cstest[seqnames(cstest) %in% c("chr10", "chr11", "chr12")]


###################################################
### chunk number 3: 
###################################################
#line 85 "Workflow.Rnw"
data(cstest)
cstest


###################################################
### chunk number 4: convert-cstest eval=FALSE
###################################################
## #line 90 "Workflow.Rnw"
## ## code used to convert the GenomeDataList to a GRangesList
## cstest <- seqapply(cstest, function(gd) {
##   gr <- do.call(c, lapply(names(gd), function(chr) {
##     pos <- gd[[chr]]
##     starts <- c(pos[["-"]] - 23L, pos[["+"]])
##     GRanges(chr, IRanges(starts, width = 24), 
##             rep(c("-", "+"), elementLengths(pos)))
##   }))
## })


###################################################
### chunk number 5: 
###################################################
#line 105 "Workflow.Rnw"
cstest$ctcf


###################################################
### chunk number 6: 
###################################################
#line 115 "Workflow.Rnw"
library(BSgenome.Mmusculus.UCSC.mm9)
seqlevels(cstest) <- seqlevels(Mmusculus)
seqlengths(cstest) <- seqlengths(Mmusculus)


###################################################
### chunk number 7: estimate.mean.fraglen
###################################################
#line 145 "Workflow.Rnw"
fraglen <- estimate.mean.fraglen(cstest$ctcf)
fraglen[!is.na(fraglen)]


###################################################
### chunk number 8: 
###################################################
#line 153 "Workflow.Rnw"
ctcf.ext <- resize(cstest$ctcf, width = 200)
ctcf.ext


###################################################
### chunk number 9: 
###################################################
#line 166 "Workflow.Rnw"
cov.ctcf <- coverage(ctcf.ext)
cov.ctcf


###################################################
### chunk number 10: 
###################################################
#line 178 "Workflow.Rnw"
islands <- slice(cov.ctcf, lower = 1)
islands


###################################################
### chunk number 11: 
###################################################
#line 185 "Workflow.Rnw"
viewSums(islands)
viewMaxs(islands)

nread.tab <- table(viewSums(islands) / 200)
depth.tab <- table(viewMaxs(islands))

nread.tab[,1:10]
depth.tab[,1:10]


###################################################
### chunk number 12: 
###################################################
#line 209 "Workflow.Rnw"
islandReadSummary <- function(x)
{
    g <- resize(x, 200)
    s <- slice(coverage(g), lower = 1)
    tab <- table(viewSums(s) / 200)
    df <- DataFrame(tab)
    colnames(df) <- c("chromosome", "nread", "count")
    df$nread <- as.integer(df$nread)
    df
}


###################################################
### chunk number 13: 
###################################################
#line 223 "Workflow.Rnw"
head(islandReadSummary(cstest$ctcf))


###################################################
### chunk number 14: 
###################################################
#line 229 "Workflow.Rnw"
nread.islands <- seqapply(cstest, islandReadSummary)
nread.islands <- stack(nread.islands, "sample")
nread.islands


###################################################
### chunk number 15: 
###################################################
#line 238 "Workflow.Rnw"
xyplot(log(count) ~ nread | sample, as.data.frame(nread.islands), 
       subset = (chromosome == "chr10" & nread <= 40), 
       layout = c(1, 2), pch = 16, type = c("p", "g"))


###################################################
### chunk number 16: 
###################################################
#line 244 "Workflow.Rnw"
plot(trellis.last.object())


###################################################
### chunk number 17: 
###################################################
#line 261 "Workflow.Rnw"
xyplot(log(count) ~ nread | sample, as.data.frame(nread.islands), 
       subset = (chromosome == "chr10" & nread <= 40), 
       layout = c(1, 2), pch = 16, type = c("p", "g"),
       panel = function(x, y, ...) {
           panel.lmline(x[1:2], y[1:2], col = "black")
           panel.xyplot(x, y, ...)
       })


###################################################
### chunk number 18: 
###################################################
#line 271 "Workflow.Rnw"
plot(trellis.last.object())


###################################################
### chunk number 19: 
###################################################
#line 279 "Workflow.Rnw"
islandDepthSummary <- function(x)
{
  g <- resize(x, 200)
  s <- slice(coverage(g), lower = 1)
  tab <- table(viewMaxs(s) / 200)
  df <- DataFrame(tab)
  colnames(df) <- c("chromosome", "depth", "count")
  df$depth <- as.integer(df$depth)
  df
}

depth.islands <- seqapply(cstest, islandDepthSummary)
depth.islands <- stack(depth.islands, "sample")

xyplot(log(count) ~ depth | sample, as.data.frame(depth.islands), 
       subset = (chromosome == "chr10" & depth <= 20), 
       layout = c(1, 2), pch = 16, type = c("p", "g"),
       panel = function(x, y, ...) {
           lambda <- 2 * exp(y[2]) / exp(y[1])
           null.est <- function(xx) {
               xx * log(lambda) - lambda - lgamma(xx + 1)
           }
           log.N.hat <- null.est(1) - y[1]
           panel.lines(1:10, -log.N.hat + null.est(1:10), col = "black")
           panel.xyplot(x, y, ...)
       })

## depth.islands <- summarizeReads(cstest, summary.fun = islandDepthSummary)



###################################################
### chunk number 20: 
###################################################
#line 311 "Workflow.Rnw"
plot(trellis.last.object())


###################################################
### chunk number 21: islandDepthPlot
###################################################
#line 319 "Workflow.Rnw"
islandDepthPlot(cov.ctcf)


###################################################
### chunk number 22: peakCutoff
###################################################
#line 332 "Workflow.Rnw"
peakCutoff(cov.ctcf, fdr = 0.0001)


###################################################
### chunk number 23: 
###################################################
#line 339 "Workflow.Rnw"
peaks.ctcf <- slice(cov.ctcf, lower = 8)
peaks.ctcf


###################################################
### chunk number 24: peakSummary
###################################################
#line 346 "Workflow.Rnw"
peaks <- peakSummary(peaks.ctcf)


###################################################
### chunk number 25: 
###################################################
#line 359 "Workflow.Rnw"
peak.depths <- viewMaxs(peaks.ctcf)

cov.pos <- coverage(ctcf.ext[strand(ctcf.ext) == "+"])
cov.neg <- coverage(ctcf.ext[strand(ctcf.ext) == "-"])

peaks.pos <- Views(cov.pos, peaks.ctcf)
peaks.neg <- Views(cov.neg, peaks.ctcf)

wpeaks <- tail(order(peak.depths$chr10), 4)
wpeaks



###################################################
### chunk number 26: 
###################################################
#line 377 "Workflow.Rnw"
coverageplot(peaks.pos$chr10[wpeaks[1]], peaks.neg$chr10[wpeaks[1]])


###################################################
### chunk number 27: 
###################################################
#line 380 "Workflow.Rnw"
plot(trellis.last.object())


###################################################
### chunk number 28: 
###################################################
#line 384 "Workflow.Rnw"
coverageplot(peaks.pos$chr10[wpeaks[2]], peaks.neg$chr10[wpeaks[2]])


###################################################
### chunk number 29: 
###################################################
#line 387 "Workflow.Rnw"
plot(trellis.last.object())


###################################################
### chunk number 30: 
###################################################
#line 393 "Workflow.Rnw"
coverageplot(peaks.pos$chr10[wpeaks[3]], peaks.neg$chr10[wpeaks[3]])


###################################################
### chunk number 31: 
###################################################
#line 396 "Workflow.Rnw"
plot(trellis.last.object())


###################################################
### chunk number 32: 
###################################################
#line 400 "Workflow.Rnw"
coverageplot(peaks.pos$chr10[wpeaks[4]], peaks.neg$chr10[wpeaks[4]])


###################################################
### chunk number 33: 
###################################################
#line 403 "Workflow.Rnw"
plot(trellis.last.object())


###################################################
### chunk number 34: 
###################################################
#line 416 "Workflow.Rnw"

## find peaks for GFP control
cov.gfp <- coverage(resize(cstest$gfp, 200))
peaks.gfp <- slice(cov.gfp, lower = 8)

peakSummary <- diffPeakSummary(peaks.gfp, peaks.ctcf)

xyplot(asinh(sums2) ~ asinh(sums1) | space,
       data = as.data.frame(peakSummary), 
       panel = function(x, y, ...) {
           panel.xyplot(x, y, ...)
           panel.abline(median(y - x), 1)
       },
       type = c("p", "g"), alpha = 0.5, aspect = "iso")



###################################################
### chunk number 35: 
###################################################
#line 433 "Workflow.Rnw"
plot(trellis.last.object())


###################################################
### chunk number 36: 
###################################################
#line 439 "Workflow.Rnw"
peakSummary <- 
    within(peakSummary,
       {
           diffs <- asinh(sums2) - asinh(sums1)
           resids <- (diffs - median(diffs)) / mad(diffs)
           up <- resids > 2
           down <- resids < -2
           change <- ifelse(up, "up", ifelse(down, "down", "flat"))
       })


###################################################
### chunk number 37: 
###################################################
#line 463 "Workflow.Rnw"
db <- makeTranscriptDbFromUCSC("mm9")
gregions <- transcripts(db)
gregions


###################################################
### chunk number 38: 
###################################################
#line 470 "Workflow.Rnw"
promoters <- flank(gregions, 1000, both = TRUE)


###################################################
### chunk number 39: 
###################################################
#line 475 "Workflow.Rnw"
peakSummary$inPromoter <- peakSummary %in% promoters
xtabs(~ inPromoter + change, peakSummary)


###################################################
### chunk number 40: 
###################################################
#line 480 "Workflow.Rnw"
peakSummary$inUpstream <- peakSummary %in% flank(gregions, 20000)
peakSummary$inGene <- peakSummary %in% gregions


###################################################
### chunk number 41: 
###################################################
#line 485 "Workflow.Rnw"
sumtab <- 
    as.data.frame(rbind(total = xtabs(~ change, peakSummary),
                        promoter = xtabs(~ change, 
                          subset(peakSummary, inPromoter)),
                        upstream = xtabs(~ change, 
                          subset(peakSummary, inUpstream)),
                        gene = xtabs(~ change, subset(peakSummary, inGene))))
##cbind(sumtab, ratio = round(sumtab[, "down"] /  sumtab[, "up"], 3))


###################################################
### chunk number 42: rtracklayer-upload eval=FALSE
###################################################
## #line 506 "Workflow.Rnw"
## library(rtracklayer)
## session <- browserSession()
## genome(session) <- "mm9"
## session$gfpCov <- cov.gfp
## session$gfpPeaks <- peaks.gfp
## session$ctcfCov <- cov.ctcf
## session$ctcfPeaks <- peaks.ctcf


###################################################
### chunk number 43: rtracklayer-view eval=FALSE
###################################################
## #line 518 "Workflow.Rnw"
## peak.ord <- order(unlist(peak.depths), decreasing=TRUE)
## peak.sort <- as(peaks.ctcf, "GRanges")[peak.ord]
## view <- browserView(session, peak.sort[1], full = c("gfpCov", "ctcfCov"))


###################################################
### chunk number 44: rtracklayer-view-5 eval=FALSE
###################################################
## #line 529 "Workflow.Rnw"
## views <- browserView(session, head(peak.sort, 5), full = c("gfpCov", "ctcfCov"))


###################################################
### chunk number 45: 
###################################################
#line 535 "Workflow.Rnw"
sessionInfo()


