###################################################
### chunk number 1: 
###################################################
#line 52 "customMethods.Rnw"
library(affy)


###################################################
### chunk number 2: 
###################################################
#line 60 "customMethods.Rnw"
normalize.AffyBatch.methods()
bgcorrect.methods()
pmcorrect.methods()
express.summary.stat.methods()


###################################################
### chunk number 3: 
###################################################
#line 69 "customMethods.Rnw"
library(affydata)
data(Dilution)
normalize.methods(Dilution)


###################################################
### chunk number 4: 
###################################################
#line 130 "customMethods.Rnw"
pmcorrect.subtractmmsometimes <- function(object) {

  ## subtract mm
  mm.subtracted <- pm(object) - mm(object)

  ## find which ones are unwanted and fix them
  invalid <- which(mm.subtracted <= 0)
  mm.subtracted[invalid] <- pm(object)[invalid]

  return(mm.subtracted)
}


###################################################
### chunk number 5: 
###################################################
#line 145 "customMethods.Rnw"
upDate.pmcorrect.methods(c(pmcorrect.methods(), "subtractmmsometimes"))


###################################################
### chunk number 6: 
###################################################
#line 152 "customMethods.Rnw"
huber <- function (y, k = 1.5, tol = 1e-06) {
    y <- y[!is.na(y)]
    n <- length(y)
    mu <- median(y)
    s <- mad(y)
    if (s == 0) 
        stop("cannot estimate scale: MAD is zero for this sample")
    repeat {
        yy <- pmin(pmax(mu - k * s, y), mu + k * s)
        mu1 <- sum(yy)/n
        if (abs(mu - mu1) < tol * s) 
            break
        mu <- mu1
    }
    list(mu = mu, s = s)
}


###################################################
### chunk number 7: 
###################################################
#line 174 "customMethods.Rnw"
computeExprVal.huber <- function(probes) {
  res <- apply(probes, 2, huber)
  mu <- unlist(lapply(res, function(x) x$mu))
  s <- unlist(lapply(res, function(x) x$s))
  return(list(exprs=mu, se.exprs=s))
}

upDate.generateExprSet.methods(c(generateExprSet.methods(), "huber"))


