###################################################
### chunk number 1: loadData
###################################################
#line 35 "AffyExtensions.Rnw"
library(affyPLM)
require(affydata)
data(Dilution)   # an example dataset provided by the affydata package
##FIXME: drop this after Dilution is updated
Dilution = updateObject(Dilution)
options(width=36)


###################################################
### chunk number 2: defaultModel
###################################################
#line 56 "AffyExtensions.Rnw"
Pset <- fitPLM(Dilution)


###################################################
### chunk number 3: accessors
###################################################
#line 60 "AffyExtensions.Rnw"
coefs(Pset)[1:5,]
se(Pset)[1:5,]


###################################################
### chunk number 4: seeDefaultOutput
###################################################
#line 82 "AffyExtensions.Rnw"
verify.output.param()


###################################################
### chunk number 5: noResidNoWeights
###################################################
#line 86 "AffyExtensions.Rnw"
Pset <- fitPLM(Dilution,output.param=list(residuals=FALSE,weights=FALSE))


###################################################
### chunk number 6: noRobustness
###################################################
#line 108 "AffyExtensions.Rnw"
Pset <- fitPLM(Dilution,model.param=list(max.its=0))


###################################################
### chunk number 7: treatmenteffect
###################################################
#line 192 "AffyExtensions.Rnw"
Pset <- fitPLM(Dilution,  MM ~ -1 + liver + scanner + probes,subset = geneNames(Dilution)[1:100])


###################################################
### chunk number 8: treatmenteffectexamine
###################################################
#line 196 "AffyExtensions.Rnw"
coefs(Pset)[1,]


###################################################
### chunk number 9: treatmenteffectexamine2
###################################################
#line 200 "AffyExtensions.Rnw"
coefs.probe(Pset)[1]


###################################################
### chunk number 10: treatmenteffectcovariate
###################################################
#line 205 "AffyExtensions.Rnw"
logliver <- log2(c(20,20,10,10))
Pset <- fitPLM(Dilution,model=PM~-1+probes+logliver+scanner, variable.type=c(logliver="covariate"),subset = geneNames(Dilution)[1:100])
coefs(Pset)[1,]


###################################################
### chunk number 11: MMcovariate
###################################################
#line 236 "AffyExtensions.Rnw"
Pset <- fitPLM(Dilution,  PM ~ MM + samples + probes,subset = geneNames(Dilution)[1:100])


###################################################
### chunk number 12: MMcovariateexamine
###################################################
#line 241 "AffyExtensions.Rnw"
coefs(Pset)[1,]
coefs.const(Pset)[1,]
coefs.probe(Pset)[1]


###################################################
### chunk number 13: probetype
###################################################
#line 269 "AffyExtensions.Rnw"
Pset <- fitPLM(Dilution,  PMMM ~ liver + probe.type + probes,subset = geneNames(Dilution)[1:100])


###################################################
### chunk number 14: probetypeexamine
###################################################
#line 274 "AffyExtensions.Rnw"
coefs(Pset)[1,]
coefs.const(Pset)[1,]
coefs.probe(Pset)[1]


###################################################
### chunk number 15: probesInTreatment
###################################################
#line 297 "AffyExtensions.Rnw"
Pset <- fitPLM(Dilution,  PM ~ -1 + liver + liver:probes,subset = geneNames(Dilution)[1:100])


###################################################
### chunk number 16: probesInTreatmentexamine
###################################################
#line 302 "AffyExtensions.Rnw"
coefs.probe(Pset)[1]


###################################################
### chunk number 17: probesInProbetype
###################################################
#line 321 "AffyExtensions.Rnw"
Pset <- fitPLM(Dilution,   PMMM ~ -1 + liver + probe.type:probes,subset = geneNames(Dilution)[1:100])
coefs.probe(Pset)[1]


###################################################
### chunk number 18: probesInProbetypeInTreatment
###################################################
#line 325 "AffyExtensions.Rnw"
Pset <- fitPLM(Dilution,   PMMM ~ -1 + liver + liver:probe.type:probes,subset = geneNames(Dilution)[1:100])
coefs.probe(Pset)[1]


###################################################
### chunk number 19: constraintExample
###################################################
#line 403 "AffyExtensions.Rnw"
data(Dilution)
##FIXME: remove next line
Dilution = updateObject(Dilution)
Pset <- fitPLM(Dilution, model = PM ~ probes + samples,constraint.type=c(samples="contr.sum"),subset = geneNames(Dilution)[1:100])
coefs.const(Pset)[1:2]
coefs(Pset)[1:2,]


