###################################################
### chunk number 1: options
###################################################
#line 35 "Overview.Rnw"
options(width=60)


###################################################
### chunk number 2: preliminaries
###################################################
#line 39 "Overview.Rnw"
library("ShortRead")


###################################################
### chunk number 3: SolexaPath-root
###################################################
#line 65 "Overview.Rnw"
exptPath <- system.file("extdata", package="ShortRead")


###################################################
### chunk number 4: SolexaPat
###################################################
#line 71 "Overview.Rnw"
sp <- SolexaPath(exptPath)
sp


###################################################
### chunk number 5: firecrest
###################################################
#line 80 "Overview.Rnw"
imageAnalysisPath(sp)
analysisPath(sp)


###################################################
### chunk number 6: readAligned-simple
###################################################
#line 114 "Overview.Rnw"
aln <- readAligned(sp, "s_2_export.txt")
aln


###################################################
### chunk number 7: filter-egs
###################################################
#line 219 "Overview.Rnw"
nfilt <- nFilter()
cfilt <- chromosomeFilter('chr5.fa')
sfilt <- strandFilter("+")
ofilt <- occurrenceFilter(withSread=FALSE)


###################################################
### chunk number 8: readAligned-filter
###################################################
#line 227 "Overview.Rnw"
chr5 <- readAligned(sp, "s_2_export.txt", filter=cfilt)


###################################################
### chunk number 9: readAligned-compose-filter
###################################################
#line 233 "Overview.Rnw"
filt <- compose(cfilt, sfilt)
chr5plus <- readAligned(sp, "s_2_export.txt", filter=filt)


###################################################
### chunk number 10: AlignedRead-filter
###################################################
#line 240 "Overview.Rnw"
chr5 <- aln[cfilt(aln)]


###################################################
### chunk number 11: aln-sread-quality
###################################################
#line 254 "Overview.Rnw"
sread(aln)
quality(aln)


###################################################
### chunk number 12: chromosomes
###################################################
#line 287 "Overview.Rnw"
whichStrand <- strand(aln)
class(whichStrand)
levels(whichStrand)
table(whichStrand, useNA="ifany")


###################################################
### chunk number 13: alignData
###################################################
#line 303 "Overview.Rnw"
alignData(aln)


###################################################
### chunk number 14: varMetadata
###################################################
#line 313 "Overview.Rnw"
varMetadata(alignData(aln))


###################################################
### chunk number 15: aln-okreads
###################################################
#line 326 "Overview.Rnw"
mapped <- !is.na(position(aln))
filtered <- alignData(aln)[["filtering"]] =="Y"
sum(!mapped) / length(aln)
sum(filtered) / length(aln)


###################################################
### chunk number 16: aln-failed
###################################################
#line 335 "Overview.Rnw"
failedAlign <- aln[filtered & !mapped]
failedAlign


###################################################
### chunk number 17: sread-filter-fail-subset
###################################################
#line 342 "Overview.Rnw"
failedReads <- sread(aln)[filtered & !mapped]


###################################################
### chunk number 18: qa
###################################################
#line 351 "Overview.Rnw"
qaSummary <- qa(sp)


###################################################
### chunk number 19:  eval=FALSE
###################################################
## #line 364 "Overview.Rnw"
## save(qaSummary, file="/path/to/file.rda")


###################################################
### chunk number 20:  eval=FALSE
###################################################
## #line 371 "Overview.Rnw"
## library("Rmpi")
## mpi.spawn.Rslaves(nsl=8)
## qaSummary <- qa(sp)
## mpi.close.Rslaves()


###################################################
### chunk number 21:  eval=FALSE
###################################################
## #line 379 "Overview.Rnw"
## library(multicore)
## qaSummary <- qa(sp)


###################################################
### chunk number 22: qa-elements
###################################################
#line 393 "Overview.Rnw"
qaSummary


###################################################
### chunk number 23: qa-readCounts
###################################################
#line 399 "Overview.Rnw"
qaSummary[["readCounts"]]
qaSummary[["baseCalls"]]


###################################################
### chunk number 24: report eval=FALSE
###################################################
## #line 416 "Overview.Rnw"
## report(qaSummary, dest="/path/to/report_directory")


###################################################
### chunk number 25: export
###################################################
#line 453 "Overview.Rnw"
pattern <- "s_2_export.txt"
fl <- file.path(analysisPath(sp), pattern)
strsplit(readLines(fl, n=1), "\t")
length(readLines(fl))


###################################################
### chunk number 26: colClasses
###################################################
#line 482 "Overview.Rnw"
colClasses <- rep(list(NULL), 21)
colClasses[9:10] <- c("DNAString", "BString")
names(colClasses)[9:10] <- c("read", "quality")


###################################################
### chunk number 27: readXStringColumns
###################################################
#line 493 "Overview.Rnw"
cols <- readXStringColumns(analysisPath(sp), pattern, colClasses)
cols


###################################################
### chunk number 28: size
###################################################
#line 510 "Overview.Rnw"
object.size(cols$read)
object.size(as.character(cols$read))


###################################################
### chunk number 29: fastq-format
###################################################
#line 526 "Overview.Rnw"
fqpattern <- "s_1_sequence.txt"
fl <- file.path(analysisPath(sp), fqpattern)
readLines(fl, 4)


###################################################
### chunk number 30: readFastq
###################################################
#line 536 "Overview.Rnw"
fq <- readFastq(sp, fqpattern)
fq


###################################################
### chunk number 31: ShortReadQ
###################################################
#line 543 "Overview.Rnw"
reads <- sread(fq)
qualities <- quality(fq)
class(qualities)
id(fq)


###################################################
### chunk number 32: ShortReadQ-subset
###################################################
#line 556 "Overview.Rnw"
fq[1:5]


###################################################
### chunk number 33: intensity-files
###################################################
#line 577 "Overview.Rnw"
int <- readIntensities(sp, withVariability=FALSE)
int


###################################################
### chunk number 34: intensities-cycle-2
###################################################
#line 584 "Overview.Rnw"
print(splom(intensity(int)[[,,2]], pch=".", cex=3))


###################################################
### chunk number 35: tables
###################################################
#line 612 "Overview.Rnw"
tbls <- tables(aln)
names(tbls)
tbls$top[1:5]
head(tbls$distribution)


###################################################
### chunk number 36: srdistance
###################################################
#line 638 "Overview.Rnw"
dist <- srdistance(sread(aln), names(tbls$top)[1])[[1]]
table(dist)[1:10]


###################################################
### chunk number 37: aln-not-near
###################################################
#line 644 "Overview.Rnw"
alnSubset <- aln[dist>4]


###################################################
### chunk number 38: polya
###################################################
#line 653 "Overview.Rnw"
countA <- alphabetFrequency(sread(aln))[,"A"] 
alnNoPolyA <- aln[countA < 30]


###################################################
### chunk number 39: readSeq
###################################################
#line 742 "Overview.Rnw"
seqFls <- list.files(baseCallPath(sp), "_seq.txt", full=TRUE)
strsplit(readLines(seqFls[[1]], 1), "\t")
colClasses <- c(rep(list(NULL), 4), "DNAString")
reads <- readXStringColumns(baseCallPath(sp), "s_1_0001_seq.txt",
                            colClasses=colClasses)


###################################################
### chunk number 40: readSeq-all
###################################################
#line 751 "Overview.Rnw"
reads <- readXStringColumns(baseCallPath(sp), "s_1_.*_seq.txt",
                            colClasses=colClasses)


###################################################
### chunk number 41: calcInt-demo
###################################################
#line 766 "Overview.Rnw"
calcInt <- function(file, cycle, verbose=FALSE)
{
    if (verbose)
        cat("calcInt", file, cycle, "\n")
    int <- readIntensities(dirname(file), basename(file),
                           intExtension="", withVariability=FALSE)
    apply(intensity(int)[,,12], 2, mean)
}


###################################################
### chunk number 42: calcInt-sapply
###################################################
#line 778 "Overview.Rnw"
intFls <- list.files(imageAnalysisPath(sp), ".*_int.txt$", full=TRUE)
lres <- lapply(intFls, calcInt, cycle=12)


###################################################
### chunk number 43: srapply-simple
###################################################
#line 788 "Overview.Rnw"
srres <- srapply(intFls, calcInt, cycle=12)
identical(lres, srres)


###################################################
### chunk number 44: srapply-mpi eval=FALSE
###################################################
## #line 794 "Overview.Rnw"
## library("Rmpi")
## mpi.spawn.Rslaves(nsl=16)
## srres <- srapply(intFls, calcInt, cycle=12)
## mpi.close.Rslaves()


###################################################
### chunk number 45: srapply-multicore eval=FALSE
###################################################
## #line 802 "Overview.Rnw"
## library(multicore)
## srres <- srapply(intFls, calcInt, cycle=12)


###################################################
### chunk number 46: sessionInfo
###################################################
#line 828 "Overview.Rnw"
toLatex(sessionInfo())


