###################################################
### chunk number 1: rpa eval=FALSE
###################################################
## #line 120 "RPA.Rnw"
## library(affydata)
## data(Dilution)
## eset <- rpa(Dilution)


###################################################
### chunk number 2: startchunk
###################################################
#line 139 "RPA.Rnw"
require(affy)
require(affydata)
data(Dilution)


###################################################
### chunk number 3: RPA.pointestimate
###################################################
#line 149 "RPA.Rnw"
require(RPA)
sets <- geneNames(Dilution)[1:2]
rpa.results <- RPA.pointestimate(Dilution, sets)


###################################################
### chunk number 4: visu eval=FALSE
###################################################
## #line 161 "RPA.Rnw"
## plot(rpa.results, set = "1000_at")


###################################################
### chunk number 5: barplots
###################################################
#line 170 "RPA.Rnw"
dat <- plot(rpa.results, set = "1000_at")


###################################################
### chunk number 6: noise
###################################################
#line 186 "RPA.Rnw"
noise <- get.probe.noise.estimates(rpa.results)


###################################################
### chunk number 7: setpriors
###################################################
#line 208 "RPA.Rnw"
alpha <- beta <- rep(1, 16)
probe.index <- 5
alpha[[probe.index]] <- 3
beta[[probe.index]] <- 1
priors <- set.priors(Dilution, set = "1000_at", alpha, beta)


###################################################
### chunk number 8: pe eval=FALSE
###################################################
## #line 218 "RPA.Rnw"
## rpa.results <- RPA.pointestimate(Dilution, sets, priors = priors)


###################################################
### chunk number 9: iter eval=FALSE
###################################################
## #line 227 "RPA.Rnw"
## res <- rpa.fit(S)


###################################################
### chunk number 10: details
###################################################
#line 356 "RPA.Rnw"
sessionInfo()


