###################################################
### chunk number 1: 
###################################################
#line 51 "ROCnotes.Rnw"
library(ROC)
print(getClass("rocc"))


###################################################
### chunk number 2: 
###################################################
#line 62 "ROCnotes.Rnw"
print(rocdemo.sca)


###################################################
### chunk number 3: 
###################################################
#line 72 "ROCnotes.Rnw"
print(dxrule.sca)


###################################################
### chunk number 4: 
###################################################
#line 78 "ROCnotes.Rnw"
set.seed(123)
state <- c(0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1)
markers <- c(1,2,1,1,2,3,3,4,2,1,1,3,2,3,2,4,5,2,3,4)+runif(20,-1,1)
roc1 <- rocdemo.sca( truth=state, data=markers, rule=dxrule.sca )


###################################################
### chunk number 5: 
###################################################
#line 88 "ROCnotes.Rnw"
plot(roc1)


###################################################
### chunk number 6: 
###################################################
#line 107 "ROCnotes.Rnw"
auc <- AUC(roc1); print(auc)
paucp4 <- pAUC(roc1,.4); print(paucp4)
rocp3 <- ROC(roc1,.3); print(rocp3)



###################################################
### chunk number 7: 
###################################################
#line 118 "ROCnotes.Rnw"
print(trapezint)



###################################################
### chunk number 8: 
###################################################
#line 136 "ROCnotes.Rnw"
library(Biobase)
data(sample.ExpressionSet)
myauc <- function(x) {
 dx <- as.numeric(sex) - 1 # phenoData is installed
 AUC( rocdemo.sca( truth=dx, data=x, rule=dxrule.sca ) )
 }
mypauc1 <- function(x) {
 dx <- as.numeric(sex) - 1
 pAUC( rocdemo.sca( truth=dx, data=x, rule=dxrule.sca ), .1 )
 }

allAUC <- esApply( sample.ExpressionSet[1:50,], 1, myauc )

allpAUC1 <- esApply( sample.ExpressionSet[1:50,], 1, mypauc1 )

print(featureNames(sample.ExpressionSet[1:50,])[order(allAUC, decreasing = TRUE)[1]])

print(featureNames(sample.ExpressionSet[1:50,])[order(allpAUC1, decreasing = TRUE)[1]])



###################################################
### chunk number 9: 
###################################################
#line 167 "ROCnotes.Rnw"
nResamp <- 5
nTiss <- ncol(exprs(sample.ExpressionSet))
nGenes <- nrow(exprs(sample.ExpressionSet[1:50,]))
out <- matrix(NA,nr=nGenes, nc=nResamp)
set.seed(123)
for (i in 1:nResamp)
 {
 TissInds <- sample(1:nTiss, size=nTiss, replace=TRUE)
 out[,i] <- esApply( sample.ExpressionSet[1:50,TissInds], 1, myauc )
 }
rout <- apply(out,2,rank)



