###################################################
### chunk number 1: installation eval=FALSE
###################################################
## #line 52 "RNAinteract.Rnw"
## source("http://bioconductor.org/biocLite.R")
## biocLite("RNAinteract")


###################################################
### chunk number 2: sourecode eval=FALSE
###################################################
## #line 58 "RNAinteract.Rnw"
## Stangle(system.file("doc", "RNAinteract.Rnw", package="RNAinteract"))


###################################################
### chunk number 3: library
###################################################
#line 65 "RNAinteract.Rnw"
library("RNAinteract")


###################################################
### chunk number 4: inputpath
###################################################
#line 71 "RNAinteract.Rnw"
inputpath = system.file("RNAinteractExample",package="RNAinteract")
inputpath


###################################################
### chunk number 5: File: Targets
###################################################
#line 84 "RNAinteract.Rnw"
inputfile <- system.file("RNAinteractExample/Targets.txt",package="RNAinteract")
T <- read.table(inputfile, sep="\t", stringsAsFactors=FALSE, header=TRUE)
head(T)


###################################################
### chunk number 6: File: Reagents
###################################################
#line 92 "RNAinteract.Rnw"
inputfile <- system.file("RNAinteractExample/Reagents.txt",package="RNAinteract")
T <- read.table(inputfile, sep="\t", stringsAsFactors=FALSE, header=TRUE)
head(T[,c("RID", "TID", "PrimerSeqFor","PrimerSeqRev","Length")])


###################################################
### chunk number 7: File: TemplateDesign
###################################################
#line 100 "RNAinteract.Rnw"
inputfile <- system.file("RNAinteractExample/TemplateDesign.txt",package="RNAinteract")
T <- read.table(inputfile, sep="\t", stringsAsFactors=FALSE, header=TRUE)
head(T)


###################################################
### chunk number 8: File: QueryDesign
###################################################
#line 108 "RNAinteract.Rnw"
inputfile <- system.file("RNAinteractExample/QueryDesign.txt",package="RNAinteract")
T <- read.table(inputfile, sep="\t", stringsAsFactors=FALSE, header=TRUE)
head(T)


###################################################
### chunk number 9: File: Platelist
###################################################
#line 116 "RNAinteract.Rnw"
inputfile <- system.file("RNAinteractExample/Platelist.txt",package="RNAinteract")
T <- read.table(inputfile, sep="\t", stringsAsFactors=FALSE, header=TRUE)
head(T)


###################################################
### chunk number 10: File: DataRNAinteractExample_1
###################################################
#line 124 "RNAinteract.Rnw"
inputfile <- system.file("RNAinteractExample/DataRNAinteractExample_1.txt",package="RNAinteract")
T <- read.table(inputfile, sep="\t", stringsAsFactors=FALSE, header=TRUE)


###################################################
### chunk number 11: create RNAinteract
###################################################
#line 131 "RNAinteract.Rnw"
sgi = createRNAinteractFromFiles(name="RNAi interaction screen", path = inputpath)
sgi


###################################################
### chunk number 12: channelnames
###################################################
#line 137 "RNAinteract.Rnw"
getChannelNames(sgi)


###################################################
### chunk number 13: main effects
###################################################
#line 146 "RNAinteract.Rnw"
sgi <- estimateMainEffect(sgi, use.query="Ctrl_Fluc")


###################################################
### chunk number 14: pairwise interaction term
###################################################
#line 153 "RNAinteract.Rnw"
sgi <- computePI(sgi)


###################################################
### chunk number 15: summarize and combine screens
###################################################
#line 159 "RNAinteract.Rnw"
sgim <- summarizeScreens(sgi, screens=c("1","2"))
sgi3 <- bindscreens(sgi, sgim)


###################################################
### chunk number 16: compute p-values
###################################################
#line 167 "RNAinteract.Rnw"
sgi3 <- computePValues(sgi3)
sgi3limma <- computePValues(sgi3, method="limma")
sgi3T2 <- computePValues(sgi3, method="HotellingT2")


###################################################
### chunk number 17: data-access-raw-data
###################################################
#line 179 "RNAinteract.Rnw"
data("sgi")

D <- getData(sgi, type="data", do.inv.trafo = TRUE)
Dplatelayout <- getData(sgi, type="data", 
	     format="platelist", do.inv.trafo = TRUE)
splots::plotScreen(Dplatelayout[["1"]][["nrCells"]],
	     nx=sgi@pdim[2], ny=sgi@pdim[1], ncol=3)
Dmatrix <- getData(sgi, type="data", 
	     format="targetMatrix", do.inv.trafo = TRUE)


###################################################
### chunk number 18: data-access raw data of a single screen
###################################################
#line 192 "RNAinteract.Rnw"
data("sgi")
D <- getData(sgi, screen="2", channel="nrCells", 
             type="data", do.inv.trafo = TRUE, format="targetMatrix")


###################################################
### chunk number 19: data-access-main-effects
###################################################
#line 199 "RNAinteract.Rnw"
Mplatelayout <- getData(sgi, type="main", design="template", 
	     screen="1", channel="nrCells", format="platelist")
splots::plotScreen(Mplatelayout, nx=sgi@pdim[2], ny=sgi@pdim[1],
	     ncol=3)


###################################################
### chunk number 20: data-access-pi
###################################################
#line 207 "RNAinteract.Rnw"
NImatrix <- getData(sgi, type="ni.model", format="targetMatrix")
PImatrix <- getData(sgi, type="pi", format="targetMatrix")
PIplatelayout <- getData(sgi, type="main", design="query",
	     screen="1", channel="nrCells", format="platelist")
splots::plotScreen(PIplatelayout, nx=sgi@pdim[2], ny=sgi@pdim[1],
             ncol=3)

p.value <- getData(sgi, type="p.value", format="targetMatrix")
q.value <- getData(sgi, type="q.value", format="targetMatrix")


###################################################
### chunk number 21: heatmaps
###################################################
#line 223 "RNAinteract.Rnw"
plotHeatmap(sgi, screen="1", channel="nrCells")


###################################################
### chunk number 22: doubleRNAi
###################################################
#line 229 "RNAinteract.Rnw"
plotDoublePerturbation(sgi, screen="1", channel="nrCells", target="Ras85D")


###################################################
### chunk number 23: simple report
###################################################
#line 236 "RNAinteract.Rnw"
outputpath = "RNAinteractHTML"
report = startReport(outputpath)
reportAnnotation(sgi3, path = outputpath, report = report)
reportStatistics(sgi3, path = outputpath, report = report)
reportGeneLists(sgi3, path = outputpath, report = report)
reportGeneLists(sgi3limma, path = outputpath, dir="hitlistlimma",
                prefix = "hitlistlimma", report = report)


###################################################
### chunk number 24: screen plots
###################################################
#line 248 "RNAinteract.Rnw"
reportMainEffects(sgi3, path = outputpath, report = report)
reportScreenData(sgi3, plotScreen.args=list(ncol=3L, do.legend=TRUE,
                                               fill = c("red","white","blue")),
                 path = outputpath, report = report)


###################################################
### chunk number 25: double perturbation plot
###################################################
#line 257 "RNAinteract.Rnw"
reportDoublePerturbation(sgi3, path = outputpath, report = report,show.labels="p.value")


###################################################
### chunk number 26: heatmaps
###################################################
#line 262 "RNAinteract.Rnw"
reportHeatmap(sgi, path=outputpath, report=report)


###################################################
### chunk number 27: endReport
###################################################
#line 268 "RNAinteract.Rnw"
save(sgi, file=file.path(outputpath, "RNAinteractExample.rda"))
endReport(report)


###################################################
### chunk number 28: browseURL eval=FALSE
###################################################
## #line 274 "RNAinteract.Rnw"
## browseURL(file.path(outputpath, "index.html"))


###################################################
### chunk number 29: sessioninfo
###################################################
#line 279 "RNAinteract.Rnw"
sessionInfo()


