###################################################
### chunk number 1: options
###################################################
#line 64 "MotIV.Rnw"
options(prompt = " ", continue = " ", width = 85)


###################################################
### chunk number 2: loading MotIV
###################################################
#line 69 "MotIV.Rnw"
library(MotIV)
path <- system.file(package="MotIV")


###################################################
### chunk number 3: Load the database
###################################################
#line 75 "MotIV.Rnw"
jaspar <- readPWMfile(paste(path,"/extdata/jaspar2010.txt",sep=""))


###################################################
### chunk number 4: Load database scores
###################################################
#line 80 "MotIV.Rnw"
jaspar.scores <- readDBScores(paste(path,"/extdata/jaspar2010_PCC_SWU.scores",sep=""))


###################################################
### chunk number 5: Read input PWM
###################################################
#line 85 "MotIV.Rnw"
example.motifs <- readPWMfile(paste(path,"/extdata/example_motifs.txt",sep=""))


###################################################
### chunk number 6: start the analysis
###################################################
#line 90 "MotIV.Rnw"
example.jaspar <- motifMatch(inputPWM=example.motifs,align="SWU",cc="PCC",database=jaspar,DBscores=jaspar.scores,top=5)


###################################################
### chunk number 7: Viewresults
###################################################
#line 95 "MotIV.Rnw"
summary(example.jaspar)
viewAlignments(example.jaspar)[[1]]
plot(example.jaspar,ncol=2,top=5)


###################################################
### chunk number 8: Viewresults
###################################################
#line 102 "MotIV.Rnw"
foxa1.filter <- setFilter(tfname="FOXA")
ap1.filter <- setFilter(tfname="AP1")
foxa1.ap1.filter <- foxa1.filter | ap1.filter
example.filter <- filter(example.jaspar,foxa1.ap1.filter, exact=F)
summary(example.filter)
plot(example.filter,ncol=2,top=5)


###################################################
### chunk number 9: loading MotIV package eval=FALSE
###################################################
## #line 116 "MotIV.Rnw"
## library(MotIV) 


###################################################
### chunk number 10: load DB
###################################################
#line 125 "MotIV.Rnw"
 jaspar <- readPWMfile(paste(path,"/extdata/jaspar2010.txt",sep=""))


###################################################
### chunk number 11: generate scores eval=FALSE
###################################################
## #line 138 "MotIV.Rnw"
## jaspar.scores <- generateDBScores(inputDB=jaspar,cc="PCC",align="SWU",nRand=1000)


###################################################
### chunk number 12: write scores eval=FALSE
###################################################
## #line 146 "MotIV.Rnw"
## writeDBScores(jaspar.scores,paste(path,"/extdata/jaspar_PCC_SWU.scores",sep=""))


###################################################
### chunk number 13: read scores
###################################################
#line 151 "MotIV.Rnw"
jaspar.scores <- readDBScores(paste(path,"/extdata/jaspar2010_PCC_SWU.scores",sep=""))


###################################################
### chunk number 14: load gadem object
###################################################
#line 162 "MotIV.Rnw"
load(paste(path, "/data/FOXA1_rGADEM.rda", sep = ""))
motifs <- getPWM(gadem)


###################################################
### chunk number 15: load gadem file
###################################################
#line 173 "MotIV.Rnw"
motifs.gadem <- readGademPWMFile(paste(path,"/extdata/observedPWMs.txt",sep=""))


###################################################
### chunk number 16: load transfac file
###################################################
#line 180 "MotIV.Rnw"
motifs.example <- readPWMfile(paste(path,"/extdata/example_motifs.txt",sep=""))


###################################################
### chunk number 17: trim input
###################################################
#line 187 "MotIV.Rnw"
motifs.trimed <- trimPWMedge(motifs, threshold=1)


###################################################
### chunk number 18: motiv analysis
###################################################
#line 194 "MotIV.Rnw"
foxa1.analysis.jaspar <- motifMatch(inputPWM=motifs,align="SWU",cc="PCC",database=jaspar,DBscores=jaspar.scores,top=5)


###################################################
### chunk number 19: motiv analysis shot
###################################################
#line 200 "MotIV.Rnw"
foxa1.analysis.jaspar <- motifMatch(motifs)


###################################################
### chunk number 20: motiv summary
###################################################
#line 213 "MotIV.Rnw"
summary(foxa1.analysis.jaspar )


###################################################
### chunk number 21: setFilter
###################################################
#line 227 "MotIV.Rnw"
f.foxa1<- setFilter( tfname="FOXA1", top=3, evalueMax=10^-5)
f.ap1 <- setFilter (tfname="AP1", top=3)


###################################################
### chunk number 22: operators
###################################################
#line 239 "MotIV.Rnw"
f.foxa1.ap1 <- f.foxa1 | f.ap1 


###################################################
### chunk number 23: filter
###################################################
#line 249 "MotIV.Rnw"
foxa1.filter <- filter(foxa1.analysis.jaspar, f.foxa1.ap1, exact=FALSE, verbose=TRUE)


###################################################
### chunk number 24: split
###################################################
#line 260 "MotIV.Rnw"
foxa1.split <- split(foxa1.analysis.jaspar, c(f.foxa1, f.ap1) , drop=FALSE, exact=FALSE, verbose=TRUE)


###################################################
### chunk number 25: combine
###################################################
#line 269 "MotIV.Rnw"
foxa1.filter.combine <- combineMotifs(foxa1.filter, c(f.foxa1, f.ap1), exact=FALSE, name=c("FOXA1", "AP1"), verbose=TRUE)


###################################################
### chunk number 26: motiv_plotMotiv
###################################################
#line 282 "MotIV.Rnw"
plot(foxa1.filter.combine ,ncol=2,top=5, rev=FALSE, main="Logo", bysim=TRUE)


###################################################
### chunk number 27: motiv alignment
###################################################
#line 291 "MotIV.Rnw"
foxa1.alignment <- viewAlignments(foxa1.filter.combine )
print(foxa1.alignment[[1]] )


###################################################
### chunk number 28: motiv_plotDistribution
###################################################
#line 300 "MotIV.Rnw"
plot(foxa1.filter.combine ,gadem,ncol=2, type="distribution", correction=TRUE, group=FALSE, bysim=TRUE, strand=FALSE, sort=TRUE, main="Distribution of FOXA")


###################################################
### chunk number 29: motiv_plotDistance
###################################################
#line 311 "MotIV.Rnw"
plot(foxa1.filter.combine ,gadem,type="distance", correction=TRUE, group=TRUE, bysim=TRUE, main="Distance between FOXA and AP-1", strand=FALSE, xlim=c(-100,100), bw=8)


###################################################
### chunk number 30: rangedData
###################################################
#line 326 "MotIV.Rnw"
foxa1.rd <- exportAsRangedData(foxa1.filter.combine["FOXA1"], gadem)
ap1.rd <- exportAsRangedData(foxa1.filter.combine["AP1"], gadem)


###################################################
### chunk number 31: motiv save
###################################################
#line 336 "MotIV.Rnw"
save(foxa1.filter.combine, file="foxa1_analysis.rda")


###################################################
### chunk number 32: motiv exportAsTransfacFile eval=FALSE
###################################################
## #line 346 "MotIV.Rnw"
## exportAsTransfacFile(foxa1.filter.combine, file="foxa1_analysis")


###################################################
### chunk number 33: bedfile eval=FALSE
###################################################
## #line 355 "MotIV.Rnw"
## library(rtracklayer)
## export(foxa1.rd, file="FOXA.bed")


###################################################
### chunk number 34: viewMotifs
###################################################
#line 366 "MotIV.Rnw"
viewMotifs(foxa1.filter.combine, n=5)


###################################################
### chunk number 35: names
###################################################
#line 374 "MotIV.Rnw"
names(foxa1.filter.combine)


###################################################
### chunk number 36: similar
###################################################
#line 382 "MotIV.Rnw"
similarity(foxa1.filter.combine)


###################################################
### chunk number 37: select
###################################################
#line 390 "MotIV.Rnw"
foxa1.selected <- foxa1.filter.combine["FOXA1"]
other.selected <- foxa1.filter.combine["FOXA1", drop=T]


###################################################
### chunk number 38: select number
###################################################
#line 397 "MotIV.Rnw"
foxa1.names <- names(foxa1.filter.combine["FOXA1"])
sum(length(gadem[foxa1.names]))


