###################################################
### chunk number 1: loadLibary
###################################################
#line 42 "MiChip.Rnw"
library(MiChip)


###################################################
### chunk number 2: defaultRawData
###################################################
#line 52 "MiChip.Rnw"
datadir <-system.file("extdata", package="MiChip")
defaultRawData <- parseRawData(datadir)


###################################################
### chunk number 3: noe
###################################################
#line 78 "MiChip.Rnw"
 noEmptiesDataSet <- removeUnwantedRows(defaultRawData, c("Empty"))


###################################################
### chunk number 4: humanDataSet
###################################################
#line 83 "MiChip.Rnw"
humanDataSet <- standardRemoveRows(defaultRawData)


###################################################
### chunk number 5: flagCorrectDataSet
###################################################
#line 90 "MiChip.Rnw"
 flagCorrectedDataSet <- correctForFlags(humanDataSet)


###################################################
### chunk number 6: flagCorrectedDataSet
###################################################
#line 98 "MiChip.Rnw"
flagCorrectedDataSet <- correctForFlags(humanDataSet, intensityCutoff = 50)


###################################################
### chunk number 7: summedData
###################################################
#line 112 "MiChip.Rnw"
summedData <- summarizeIntensitiesAsMedian(flagCorrectedDataSet,minSumlength = 0, madAdjust=FALSE)


###################################################
### chunk number 8: plotIntensities
###################################################
#line 121 "MiChip.Rnw"
plotIntensitiesScatter(exprs(summedData), NULL, "MiChipDemX", "SummarizedScatter")


###################################################
### chunk number 9: boxplotSummed
###################################################
#line 136 "MiChip.Rnw"
 boxplotData(exprs(summedData), "MiChipDemX", "Summarized")


###################################################
### chunk number 10: mednormedData
###################################################
#line 155 "MiChip.Rnw"
mednormedData <- normalizePerChipMedian(summedData)


###################################################
### chunk number 11: outputAnnot
###################################################
#line 163 "MiChip.Rnw"
outputAnnotatedDataMatrix(mednormedData, "MiChipDemo", "medNormedIntensity",  "exprs")


###################################################
### chunk number 12: myNormedEset
###################################################
#line 170 "MiChip.Rnw"
datadir <-system.file("extdata", package="MiChip")
 myNormedEset <- workedExampleMedianNormalize("NormedDemo", intensityCutoff = 50,datadir)


