###################################################
### chunk number 1: arguments
###################################################
#line 42 "UsingMCRestimate.Rnw"
library(MCRestimate)
library(randomForest)
library(golubEsets)
data(Golub_Train)
class.colum <- "ALL.AML"


###################################################
### chunk number 2: the functions
###################################################
#line 50 "UsingMCRestimate.Rnw"
savepdf =function(x,file,w=10,h=5){pdf(file=file,width=w,height=w);x;dev.off()}
options(width=50)


###################################################
### chunk number 3: METHOD CHOISE
###################################################
#line 67 "UsingMCRestimate.Rnw"
Preprocessingfunctions        <- c("varSel.highest.var")
list.of.poss.parameter        <- list(var.numbers=c(250,1000))


###################################################
### chunk number 4: METHOD CHOISE
###################################################
#line 85 "UsingMCRestimate.Rnw"
class.function                    <- "RF.wrap"


###################################################
### chunk number 5: PLOT PARAMETER
###################################################
#line 101 "UsingMCRestimate.Rnw"
plot.label               <- "Samples"


###################################################
### chunk number 6: ARGUMENTS FOR CROSS-VALIDSATION
###################################################
#line 110 "UsingMCRestimate.Rnw"
cross.outer        <- 2
cross.repeat       <- 3
cross.inner        <- 2


###################################################
### chunk number 7: RF.make
###################################################
#line 119 "UsingMCRestimate.Rnw"
RF.estimate <- MCRestimate(Golub_Train,
                        class.colum,
                        classification.fun="RF.wrap",
                        thePreprocessingMethods=Preprocessingfunctions,
                        poss.parameters=list.of.poss.parameter,
                        cross.outer=cross.outer,
                        cross.inner=cross.inner,
                        cross.repeat=cross.repeat,
                        plot.label=plot.label)


###################################################
### chunk number 8: rf.show
###################################################
#line 131 "UsingMCRestimate.Rnw"
class(RF.estimate)


###################################################
### chunk number 9: RF eval=FALSE
###################################################
## #line 138 "UsingMCRestimate.Rnw"
## plot(RF.estimate,rownames.from.object=TRUE, main="Random Forest")


###################################################
### chunk number 10: rf.save
###################################################
#line 142 "UsingMCRestimate.Rnw"
savepdf(plot(RF.estimate,rownames.from.object=TRUE, main="Random Forest"),"RF.pdf")


###################################################
### chunk number 11: 
###################################################
#line 158 "UsingMCRestimate.Rnw"
RF.classifier <- ClassifierBuild (Golub_Train, 
                                 class.colum,
                                 classification.fun="RF.wrap",
				 thePreprocessingMethods=Preprocessingfunctions,
                                 poss.parameters=list.of.poss.parameter,
                                 cross.inner=cross.inner)


###################################################
### chunk number 12: 
###################################################
#line 168 "UsingMCRestimate.Rnw"
names(RF.classifier)


###################################################
### chunk number 13: test
###################################################
#line 178 "UsingMCRestimate.Rnw"
data(Golub_Test)
RF.classifier$classifier.for.exprSet(Golub_Test)


