###################################################
### chunk number 1:  eval=FALSE
###################################################
## #line 109 "LPE.Rnw"
## packageDescription("LPE")


###################################################
### chunk number 2: 
###################################################
#line 119 "LPE.Rnw"
set.seed(0) 


###################################################
### chunk number 3: 
###################################################
#line 124 "LPE.Rnw"
library(LPE) 


###################################################
### chunk number 4: 
###################################################
#line 135 "LPE.Rnw"
data(Ley)
dim(Ley)
head(Ley)
Ley.subset <- Ley[seq(1000),]


###################################################
### chunk number 5: 
###################################################
#line 156 "LPE.Rnw"
Ley.normalized <- Ley.subset
Ley.normalized[,2:7] <- preprocess(Ley.subset[,2:7], data.type = "MAS5")
Ley.normalized[1:3,]


###################################################
### chunk number 6: 
###################################################
#line 164 "LPE.Rnw"
Ley.final <- Ley.normalized[substring(Ley.normalized$ID,1,4) !="AFFX",] 
dim(Ley.final)
Ley.final[1:3,]


###################################################
### chunk number 7: 
###################################################
#line 176 "LPE.Rnw"
var.Naive <- baseOlig.error(Ley.final[,2:4],q=0.01)
dim(var.Naive)
var.Naive[1:3,]


###################################################
### chunk number 8: 
###################################################
#line 185 "LPE.Rnw"
var.Activated <- baseOlig.error(Ley.final[,5:7], q=0.01)
dim(var.Activated)
var.Activated[1:3,]


###################################################
### chunk number 9: 
###################################################
#line 199 "LPE.Rnw"
lpe.val <- data.frame(lpe(Ley.final[,5:7], Ley.final[,2:4], 
                          var.Activated, var.Naive,
                          probe.set.name=Ley.final$ID)
                      )

lpe.val <- round(lpe.val, digits=2)
dim (lpe.val)
lpe.val[1:3,]


###################################################
### chunk number 10: 
###################################################
#line 220 "LPE.Rnw"
fdr.BH <- fdr.adjust(lpe.val, adjp="BH")
dim(fdr.BH)
round(fdr.BH[1:4, ],2)


###################################################
### chunk number 11: 
###################################################
#line 232 "LPE.Rnw"
fdr.resamp <- fdr.adjust(lpe.val, adjp="resamp", iterations=2)
fdr.resamp


###################################################
### chunk number 12: 
###################################################
#line 250 "LPE.Rnw"
Bonferroni.adjp <- fdr.adjust(lpe.val, adjp="Bonferroni")
head(Bonferroni.adjp)


