###################################################
### chunk number 1: 
###################################################
#line 6 "withShortRead.Rnw"
options(width=80)


###################################################
### chunk number 2: packages
###################################################
#line 45 "withShortRead.Rnw"
require(Genominator)
require(ShortRead)
require(yeastRNASeq)


###################################################
### chunk number 3: yeastAligned
###################################################
#line 64 "withShortRead.Rnw"
data(yeastAligned)
yeastAligned[[1]]
sapply(yeastAligned, length)


###################################################
### chunk number 4: filesInYeastRNASeq
###################################################
#line 72 "withShortRead.Rnw"
list.files(file.path(system.file(package = "yeastRNASeq"), "reads"), 
           pattern = "bowtie")


###################################################
### chunk number 5: chrMap
###################################################
#line 100 "withShortRead.Rnw"
chrMap <- paste("Scchr", sprintf("%02d", 1:16), sep = "")
unique(chromosome((yeastAligned[[1]])))


###################################################
### chunk number 6: filesArgument
###################################################
#line 112 "withShortRead.Rnw"
files <- list.files(file.path(system.file(package = "yeastRNASeq"), "reads"), 
                    pattern = "bowtie", full.names = TRUE)
names(files) <- sub("_f\\.bowtie\\.gz", "", basename(files))
names(files)


###################################################
### chunk number 7: importFromAlignedReads
###################################################
#line 127 "withShortRead.Rnw"
eData <- importFromAlignedReads(files, chrMap = chrMap,
                                dbFilename = "my.db",
                                tablename = "raw", type = "Bowtie")
eData
head(eData)


###################################################
### chunk number 8: biomaRt eval=FALSE
###################################################
## #line 156 "withShortRead.Rnw"
## require(biomaRt)
## mart <- useMart("ensembl", "scerevisiae_gene_ensembl")
## attributes.gene <- c("ensembl_gene_id", "chromosome_name",  "start_position", 
##                      "end_position", "strand", "gene_biotype")
## attributes.tr <- c("ensembl_gene_id", "ensembl_transcript_id", "ensembl_exon_id", "chromosome_name",  "start_position", 
##                    "end_position", "strand", "gene_biotype", "exon_chrom_start", "exon_chrom_end", "rank")
## ensembl.gene <- getBM(attributes = attributes.gene,  mart = mart)
## ensembl.transcript <- getBM(attributes = attributes.tr,  mart = mart)


###################################################
### chunk number 9: ensemblAnno
###################################################
#line 170 "withShortRead.Rnw"
data(yeastAnno.sources)
ensembl.gene <- yeastAnno.sources$ensembl.gene
ensembl.transcript <- yeastAnno.sources$ensembl.transcript
head(ensembl.gene, n = 2)
head(ensembl.transcript, n = 2)
dim(ensembl.gene)
dim(ensembl.transcript)
subset(ensembl.gene, ensembl_gene_id == "YPR098C")
subset(ensembl.transcript, ensembl_gene_id == "YPR098C")
length(unique(ensembl.transcript$ensembl_transcript_id))


###################################################
### chunk number 10: rtracklayer eval=FALSE
###################################################
## #line 212 "withShortRead.Rnw"
## require(rtracklayer)
## session <- browserSession()
## genome(session) <- "sacCer2"
## ucsc.sgdGene <- getTable(ucscTableQuery(session, "sgdGene"))
## ucsc.ensGene <- getTable(ucscTableQuery(session, "ensGene"))


###################################################
### chunk number 11: yeastAnno.sources eval=FALSE
###################################################
## #line 220 "withShortRead.Rnw"
## yeastAnno.sources <- list(ensembl.gene = ensembl.gene,
##                           ensembl.transcript = ensembl.transcript,
##                           ucsc.sgdGene = ucsc.sgdGene,
##                           ucsc.ensGene = ucsc.ensGene)
## save(yeastAnno.sources, file = "yeastAnno.sources.rda")


###################################################
### chunk number 12: ucscAnno
###################################################
#line 230 "withShortRead.Rnw"
data(yeastAnno.sources)
ucsc.sgdGene <- yeastAnno.sources$ucsc.sgdGene
ucsc.ensGene <- yeastAnno.sources$ucsc.ensGene
head(ucsc.sgdGene, n = 2)
head(ucsc.ensGene, n = 2)
dim(ucsc.sgdGene)
dim(ucsc.ensGene)
subset(ucsc.sgdGene, name == "YPR098C")
subset(ucsc.ensGene, name == "YPR098C")
subset(ucsc.sgdGene, name == "YER102W")
subset(ucsc.ensGene, name == "YER102W")


###################################################
### chunk number 13: yAnno
###################################################
#line 286 "withShortRead.Rnw"
yAnno <- yeastAnno.sources$ensembl.transcript
yAnno$chr <- match(yAnno$chr, c(as.character(as.roman(1:16)), "MT", "2-micron"))
yAnno$start <- yAnno$start_position
yAnno$end <- yAnno$end_position
rownames(yAnno) <- yAnno$ensembl_exon_id
yAnno.simple <- yAnno[yAnno$chr %in% 1:16, c("chr", "start", "end", "strand")]
head(yAnno.simple, n = 2)
head(yAnno, n = 2)


###################################################
### chunk number 14: validAnno
###################################################
#line 301 "withShortRead.Rnw"
validAnnotation(yAnno)


###################################################
### chunk number 15: geneCounts.1
###################################################
#line 308 "withShortRead.Rnw"
geneCounts.1 <- summarizeByAnnotation(eData, yAnno, ignoreStrand = TRUE)
head(geneCounts.1)


###################################################
### chunk number 16: geneCounts.2
###################################################
#line 324 "withShortRead.Rnw"
geneCounts.2 <- summarizeByAnnotation(eData, yAnno, ignoreStrand = TRUE, 
                                      groupBy = "ensembl_gene_id")
head(geneCounts.2)


###################################################
### chunk number 17: makeGeneRep
###################################################
#line 348 "withShortRead.Rnw"
yAnno.UI <- makeGeneRepresentation(yAnno, type = "UIgene", gene.id = "ensembl_gene_id",
                                   transcript.id = "ensembl_transcript_id")
head(yAnno.UI)


###################################################
### chunk number 18: gof eval=FALSE
###################################################
## #line 364 "withShortRead.Rnw"
## groups <- gsub("_[0-9]_f", "", colnames(geneCounts))
## groups
## plot(regionGoodnessOfFit(geneCounts, groups), chisq = TRUE)


###################################################
### chunk number 19: computePrimingWeights
###################################################
#line 403 "withShortRead.Rnw"
weightsList <- lapply(yeastAligned, computePrimingWeights, 
                      unbiasedIndex = 20:21, weightsLength = 6L)
sapply(weightsList, summary)


###################################################
### chunk number 20: addPrimingWeights
###################################################
#line 411 "withShortRead.Rnw"
yeastAligned2 <- mapply(addPrimingWeights, yeastAligned, weightsList)
alignData(yeastAligned2[[1]])
head(alignData(yeastAligned2[[1]])$weights)


###################################################
### chunk number 21: importWithWeights
###################################################
#line 421 "withShortRead.Rnw"
eData2 <- importFromAlignedReads(yeastAligned2, chrMap = chrMap,
                                 dbFilename = "my.db", tablename = "weights")


###################################################
### chunk number 22: reweightedCounts
###################################################
#line 428 "withShortRead.Rnw"
reweightedCounts <- summarizeByAnnotation(eData2, yAnno, ignoreStrand = TRUE, 
                                          groupBy = "ensembl_gene_id")
head(reweightedCounts)


###################################################
### chunk number 23: sessionInfo
###################################################
#line 436 "withShortRead.Rnw"
toLatex(sessionInfo())


