/*
 * Decompiled with CFR 0.152.
 */
package jas.hist.test;

import jas.hist.HasStyle;
import jas.hist.JASHist;
import jas.hist.JASHist1DHistogramStyle;
import jas.hist.JASHistStyle;
import jas.hist.XYDataSource;
import javax.swing.JFrame;

public class XYTestData
implements XYDataSource,
HasStyle {
    private double[] x;
    private double[] y;

    public XYTestData() {
        int n = 100;
        this.x = new double[n];
        this.y = new double[n];
        for (int i = 0; i < n; ++i) {
            this.x[i] = this.y[i] = (double)i / (double)n;
        }
    }

    public int getAxisType() {
        return 1;
    }

    public String getTitle() {
        return "Test XY Data";
    }

    public double getMinusError(int index) {
        return Math.sqrt(this.x[index]);
    }

    public double getPlusError(int index) {
        return Math.sqrt(this.x[index]);
    }

    public double getX(int index) {
        return this.x[index];
    }

    public double getY(int index) {
        return this.y[index];
    }

    public int getNPoints() {
        return this.x.length;
    }

    public JASHistStyle getStyle() {
        JASHist1DHistogramStyle style = new JASHist1DHistogramStyle();
        style.setShowHistogramBars(false);
        style.setShowDataPoints(true);
        style.setShowLinesBetweenPoints(true);
        style.setShowErrorBars(false);
        return style;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("XY Test");
        JASHist plot = new JASHist();
        plot.addData(new XYTestData()).show(true);
        frame.getContentPane().add(plot);
        frame.setSize(400, 400);
        frame.show();
    }
}

