/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.goodies;

import com.sun.glf.goodies.LitSurface;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class SpotLight {
    static final int LIGHT_PRECISION = 1024;
    double[] Iw = new double[]{1.0, 1.0, 1.0};
    int np = 4;
    double Imin = 0.9;
    int Rx;
    int Ry;
    int Rz;
    int Lx;
    int Ly;
    int Lz;
    double cosLimit;
    public static final String USAGE = "java com.sun.glf.goodies.SpotLight x0 y0 w h";
    public static final int N_ARGS = 4;

    public SpotLight(double d, Point2D point2D, Point2D point2D2) {
        this.processLigthFromEllipse(d, point2D, point2D2, 1.0, Color.white);
    }

    private void processLigthFromEllipse(double d, Point2D point2D, Point2D point2D2, double d2, Color color) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Negative intensity not allowed");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        double d3 = point2D.distance(point2D2) / (2.0 * d);
        double d4 = Math.acos(this.Imin);
        double d5 = Math.asin(d3 * Math.cos(d4));
        double d6 = Math.cos(d5);
        double d7 = Math.sin(d5);
        double d8 = Math.tan(d5);
        double d9 = Math.cos(d4);
        double d10 = Math.sin(d4);
        double d11 = Math.tan(d4);
        double d12 = d6 * d6;
        double d13 = d7 * d7;
        double d14 = d9 * d9;
        double d15 = d10 * d10;
        double d16 = d11 * d11;
        double d17 = d4;
        this.cosLimit = Math.cos(d17);
        double d18 = d * (d12 - d16 * d13) / d11;
        double d19 = (point2D.getX() + point2D2.getX()) / 2.0;
        double d20 = (point2D.getY() + point2D2.getY()) / 2.0;
        double d21 = point2D.distance(point2D2);
        double d22 = d21 != 0.0 ? (point2D.getX() - point2D2.getX()) / d21 : 0.0;
        double d23 = d21 != 0.0 ? (point2D.getY() - point2D2.getY()) / d21 : 0.0;
        double d24 = d18 * d6 * d7 / (d14 * d12 - d15 * d13);
        this.Rx = (int)(d19 + d24 * d22);
        this.Ry = (int)(d20 + d24 * d23);
        this.Rz = (int)d18;
        if (this.Rz == 0) {
            this.Rz = 1;
        }
        double d25 = d22 * d18 * d8;
        double d26 = d23 * d18 * d8;
        double d27 = d18;
        double d28 = Math.sqrt(d25 * d25 + d26 * d26 + d27 * d27);
        this.Lx = (int)(1024.0 * (d25 /= d28));
        this.Ly = (int)(1024.0 * (d26 /= d28));
        this.Lz = (int)(1024.0 * (d27 /= d28));
        this.Iw[0] = d2 * (double)color.getRed() / 255.0;
        this.Iw[1] = d2 * (double)color.getGreen() / 255.0;
        this.Iw[2] = d2 * (double)color.getBlue() / 255.0;
    }

    public SpotLight(Rectangle2D rectangle2D) {
        this(rectangle2D, Color.white, 1.0, 0.0);
    }

    public SpotLight(Rectangle2D rectangle2D, double d) {
        this(rectangle2D, Color.white, 1.0, d);
    }

    public SpotLight(Rectangle2D rectangle2D, Color color) {
        this(rectangle2D, color, 1.0, 0.0);
    }

    public SpotLight(Rectangle2D rectangle2D, Color color, double d, double d2) {
        this(rectangle2D, color, d, d2, 4);
    }

    public SpotLight(Rectangle2D rectangle2D, Color color, double d, double d2, int n) {
        double d3;
        if (n <= 0) {
            throw new IllegalArgumentException("np should be 1 or more");
        }
        this.np = n;
        rectangle2D = (Rectangle2D)rectangle2D.clone();
        double d4 = rectangle2D.getX();
        double d5 = rectangle2D.getY();
        double d6 = rectangle2D.getWidth();
        double d7 = rectangle2D.getHeight();
        boolean bl = true;
        if (d6 < d7) {
            d3 = d6;
            d6 = d7;
            d7 = d3;
            bl = false;
        }
        d3 = d6 / 2.0;
        double d8 = d7 / 2.0;
        double d9 = Math.sqrt(1.0 - d8 * d8 / (d3 * d3));
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        if (bl) {
            double_2.x = d4 + d3 * (1.0 + d9);
            double_2.y = d5 + d8;
            double_.x = d4 + d3 * (1.0 - d9);
            double_.y = d5 + d8;
        } else {
            double_2.y = d5 + d3 * (1.0 + d9);
            double_2.x = d4 + d8;
            double_.y = d5 + d3 * (1.0 - d9);
            double_.x = d4 + d8;
        }
        if (d2 != 0.0) {
            AffineTransform affineTransform = null;
            affineTransform = bl ? AffineTransform.getRotateInstance(d2, d4, d5 + d8) : AffineTransform.getRotateInstance(d2, d4 + d8, d5);
            affineTransform.transform(double_, double_);
            affineTransform.transform(double_2, double_2);
        }
        this.processLigthFromEllipse(d3, double_, double_2, d, color);
    }

    public int getNp() {
        return this.np;
    }

    public void setNp(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.np = n;
    }

    public final void getFlatIntensity(LitSurface litSurface, int n, int n2, double[] dArray) {
        double d;
        double d2;
        double d3 = this.Rx - n;
        double d4 = this.Ry - n2;
        double d5 = this.Rz;
        if ((d2 = ((d3 /= (d = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5))) * (double)this.Lx + (d4 /= d) * (double)this.Ly + (d5 /= d) * (double)this.Lz) / 1024.0) > this.cosLimit) {
            double d6 = this.cosLimit / d2;
            d6 *= d6;
            d6 *= d6;
            d6 *= d6;
            double d7 = Math.pow(d2, this.np);
            d6 = d7 * (1.0 - d6);
            double d8 = litSurface.kd * d5;
            d8 = d8 > 0.0 ? d8 : 0.0;
            double d9 = d5 / 1024.0;
            double d10 = litSurface.ks * Math.pow(d5, litSurface.ns);
            d10 = d10 > 0.0 ? d10 : 0.0;
            dArray[0] = this.Iw[0] * (d6 *= d8 + d10);
            dArray[1] = this.Iw[1] * d6;
            dArray[2] = this.Iw[2] * d6;
        } else {
            dArray[0] = 0.0;
            dArray[1] = 0.0;
            dArray[2] = 0.0;
        }
    }

    public final void getTexturedIntensity(LitSurface litSurface, int n, int n2, double[] dArray) {
        double d;
        double d2;
        double d3 = this.Rx - n;
        double d4 = this.Ry - n2;
        double d5 = this.Rz;
        if ((d2 = ((d3 /= (d = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5))) * (double)this.Lx + (d4 /= d) * (double)this.Ly + (d5 /= d) * (double)this.Lz) / 1024.0) > this.cosLimit) {
            double d6 = this.cosLimit / d2;
            d6 *= d6;
            d6 *= d6;
            d6 *= d6;
            d6 = Math.pow(d2, this.np) * (1.0 - d6);
            int[] nArray = litSurface.elevationMap.getNormal(n, n2);
            double d7 = ((double)nArray[0] * d3 + (double)nArray[1] * d4 + (double)nArray[2] * d5) / 1024.0;
            d7 = d7 > 0.0 ? d7 : 0.0;
            double d8 = litSurface.ks * Math.pow((double)(2 * nArray[2]) * d7 / 1024.0 - d5, litSurface.ns);
            d8 = d8 > 0.0 ? d8 : 0.0;
            dArray[0] = this.Iw[0] * (d6 *= litSurface.kd * d7 + d8);
            dArray[1] = this.Iw[1] * d6;
            dArray[2] = this.Iw[2] * d6;
        } else {
            dArray[0] = 0.0;
            dArray[1] = 0.0;
            dArray[2] = 0.0;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 4) {
            System.out.println(USAGE);
            System.exit(0);
        }
        int n = 0;
        double d = Integer.parseInt(stringArray[n++]);
        double d2 = Integer.parseInt(stringArray[n++]);
        double d3 = Integer.parseInt(stringArray[n++]);
        double d4 = Integer.parseInt(stringArray[n++]);
        System.out.println("=====================================================");
        System.out.println("Bounding ellipse : " + d + "/" + d2 + "/" + d3 + "/" + d4);
        System.out.println("=====================================================");
        System.out.println();
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        SpotLight spotLight = new SpotLight(double_);
    }
}

