/*
 * Decompiled with CFR 0.152.
 */
package com.sosnoski.util.array;

import com.sosnoski.util.array.ArrayBase;

public class DoubleArray
extends ArrayBase {
    protected double[] m_baseArray;

    public DoubleArray(int n, int n2) {
        super(n, n2, Double.TYPE);
    }

    public DoubleArray(int n) {
        super(n, Double.TYPE);
    }

    public DoubleArray() {
        this(8);
    }

    public DoubleArray(DoubleArray doubleArray) {
        super(doubleArray);
    }

    protected final Object getArray() {
        return this.m_baseArray;
    }

    protected final void setArray(Object object) {
        this.m_baseArray = (double[])object;
    }

    public final int add(double d) {
        int n = this.getAddIndex();
        this.m_baseArray[n] = d;
        return n;
    }

    public void add(int n, double d) {
        this.makeInsertSpace(n);
        this.m_baseArray[n] = d;
    }

    public final double get(int n) {
        if (n < this.m_countPresent) {
            return this.m_baseArray[n];
        }
        throw new ArrayIndexOutOfBoundsException("Invalid index value");
    }

    public final void set(int n, double d) {
        if (n >= this.m_countPresent) {
            throw new ArrayIndexOutOfBoundsException("Invalid index value");
        }
        this.m_baseArray[n] = d;
    }

    public double[] toArray() {
        return (double[])this.buildArray(Double.TYPE, 0, this.m_countPresent);
    }

    public double[] toArray(int n, int n2) {
        return (double[])this.buildArray(Double.TYPE, n, n2);
    }

    public Object clone() {
        return new DoubleArray(this);
    }
}

