###################################################
### chunk number 1: 
###################################################
#line 50 "GEOmetadb.Rnw"
options(width=55)


###################################################
### chunk number 2: 
###################################################
#line 58 "GEOmetadb.Rnw"
library(GEOmetadb)


###################################################
### chunk number 3: 
###################################################
#line 63 "GEOmetadb.Rnw"
getSQLiteFile()


###################################################
### chunk number 4: 
###################################################
#line 71 "GEOmetadb.Rnw"
file.info('GEOmetadb.sqlite')


###################################################
### chunk number 5: 
###################################################
#line 76 "GEOmetadb.Rnw"
con <- dbConnect(SQLite(),'GEOmetadb.sqlite')
dbDisconnect(con)


###################################################
### chunk number 6: 
###################################################
#line 91 "GEOmetadb.Rnw"
con <- dbConnect(SQLite(),'GEOmetadb.sqlite')


###################################################
### chunk number 7: 
###################################################
#line 96 "GEOmetadb.Rnw"
geo_tables <- dbListTables(con)
geo_tables


###################################################
### chunk number 8: 
###################################################
#line 102 "GEOmetadb.Rnw"
dbListFields(con,'gse')


###################################################
### chunk number 9: 
###################################################
#line 107 "GEOmetadb.Rnw"
sqliteQuickSQL(con,'PRAGMA TABLE_INFO(gpl)')


###################################################
### chunk number 10: 
###################################################
#line 114 "GEOmetadb.Rnw"
rs <- dbGetQuery(con,'select * from gse limit 5')
rs[,1:7]


###################################################
### chunk number 11: 
###################################################
#line 120 "GEOmetadb.Rnw"
rs <- dbGetQuery(con,paste("select gse,title from gse where",
                           "contributor like '%Sean%Davis%'",sep=" "))
rs


###################################################
### chunk number 12: 
###################################################
#line 128 "GEOmetadb.Rnw"
rs <- dbGetQuery(con,paste("select gsm,supplementary_file",
                           "from gsm where gpl='GPL96'",
                           "and supplementary_file like '%CEL.gz'"))
dim(rs)


###################################################
### chunk number 13: 
###################################################
#line 137 "GEOmetadb.Rnw"
rs <- dbGetQuery(con,paste("select gpl.bioc_package,gsm.gpl,",
                           "gsm,gsm.supplementary_file",
                           "from gsm join gpl on gsm.gpl=gpl.gpl",
                           "where gpl.manufacturer='Affymetrix'",
                           "and gsm.supplementary_file like '%CEL.gz' "))
rs[1:5,]


###################################################
### chunk number 14: 
###################################################
#line 147 "GEOmetadb.Rnw"
getTableCounts <- function(tableName,conn) {
  sql <- sprintf("select count(*) from %s",tableName)
  return(dbGetQuery(conn,sql)[1,1])
}
do.call(rbind,sapply(geo_tables,getTableCounts,con,simplify=FALSE))


###################################################
### chunk number 15: 
###################################################
#line 161 "GEOmetadb.Rnw"
conversion <- geoConvert('GPL96')


###################################################
### chunk number 16: 
###################################################
#line 167 "GEOmetadb.Rnw"
lapply(conversion, dim)
conversion$gse[1:5,]
conversion$gsm[1:5,]
conversion$gds[1:5,]
conversion$sMatrix[1:5,]


###################################################
### chunk number 17: 
###################################################
#line 179 "GEOmetadb.Rnw"
getBiocPlatformMap(con, bioc=c('hgu133a','hgu95av2'))


###################################################
### chunk number 18: 
###################################################
#line 186 "GEOmetadb.Rnw"
sql <- paste("SELECT DISTINCT gse.title,gse.gse",
             "FROM",
             "  gsm JOIN gse_gsm ON gsm.gsm=gse_gsm.gsm",
             "  JOIN gse ON gse_gsm.gse=gse.gse",
             "  JOIN gse_gpl ON gse_gpl.gse=gse.gse",
             "  JOIN gpl ON gse_gpl.gpl=gpl.gpl",
             "WHERE",
             "  gsm.molecule_ch1 like '%total RNA%' AND",
             "  gse.title LIKE '%breast cancer%' AND",
             "  gpl.organism LIKE '%Homo sapiens%'",sep=" ")
rs <- dbGetQuery(con,sql)
dim(rs)
print(rs[1:5,],right=FALSE)


###################################################
### chunk number 19: 
###################################################
#line 204 "GEOmetadb.Rnw"
dbDisconnect(con)


###################################################
### chunk number 20: 
###################################################
#line 209 "GEOmetadb.Rnw"
file.remove('GEOmetadb.sqlite')


