###################################################
### chunk number 1: 
###################################################
#line 46 "CGHcall.Rnw"
library(CGHcall)
data(WiltingData)
Wilting <- cghRaw(WiltingData)


###################################################
### chunk number 2: 
###################################################
#line 61 "CGHcall.Rnw"
cghdata <- preprocess(Wilting, maxmiss=30, nchrom=22)


###################################################
### chunk number 3: 
###################################################
#line 67 "CGHcall.Rnw"
tumor.prop <- c(0.75, 0.9, 0.8, 1, 1)
norm.cghdata <- normalize(cghdata, method="median", cellularity=tumor.prop, smoothOutliers=TRUE)


###################################################
### chunk number 4: 
###################################################
#line 74 "CGHcall.Rnw"
norm.cghdata <- norm.cghdata[,1:2]
seg.cghdata <- segmentData(norm.cghdata, method="DNAcopy")


###################################################
### chunk number 5: 
###################################################
#line 81 "CGHcall.Rnw"
postseg.cghdata <- postsegnormalize(seg.cghdata)


###################################################
### chunk number 6: 
###################################################
#line 87 "CGHcall.Rnw"
result <- CGHcall(postseg.cghdata)


###################################################
### chunk number 7: 
###################################################
#line 93 "CGHcall.Rnw"
result <- ExpandCGHcall(result,postseg.cghdata)


###################################################
### chunk number 8: 
###################################################
#line 102 "CGHcall.Rnw"
plot(result[,1])


###################################################
### chunk number 9: 
###################################################
#line 109 "CGHcall.Rnw"
plot(result[,2])


###################################################
### chunk number 10: 
###################################################
#line 119 "CGHcall.Rnw"
plot.summary(result)


