###################################################
### chunk number 1: start
###################################################
#line 14 "vignette.Rnw"
library(CGEN)


###################################################
### chunk number 2: load data
###################################################
#line 22 "vignette.Rnw"
data(Xdata, package="CGEN")
Xdata[1:5, ]


###################################################
### chunk number 3: dummy vars
###################################################
#line 30 "vignette.Rnw"
for (a in unique(Xdata[, "age.group"])) {
  dummyVar <- paste("age.group_", a, sep="")
  Xdata[, dummyVar] <- 0
  temp <- Xdata[, "age.group"] == a
  if (any(temp)) Xdata[temp, dummyVar] <- 1
}


###################################################
### chunk number 4: table
###################################################
#line 40 "vignette.Rnw"
table(Xdata[, "case.control"], Xdata[, "age.group"], exclude=NULL)


###################################################
### chunk number 5: snp.logistic
###################################################
#line 46 "vignette.Rnw"
mainVars <- c("oral.years", "n.children", "age.group_1",
              "age.group_2", "age.group_3", "age.group_5")
fit <- snp.logistic(Xdata, "case.control", "BRCA.status",
                     main.vars=mainVars, 
                     int.vars=c("oral.years", "n.children"), 
                     strata.var="ethnic.group")


###################################################
### chunk number 6: summary table
###################################################
#line 56 "vignette.Rnw"
getSummary(fit)


###################################################
### chunk number 7: Wald test
###################################################
#line 60 "vignette.Rnw"
getWaldTest(fit, c("BRCA.status", "BRCA.status:oral.years", "BRCA.status:n.children"))


###################################################
### chunk number 8: snp.list
###################################################
#line 76 "vignette.Rnw"
g <- system.file("sampleData", "SNPdata.rda", package="CGEN")
snp.list <- list(file=g, file.type=1, delimiter="|", in.miss="NA")


###################################################
### chunk number 9: pheno.list
###################################################
#line 82 "vignette.Rnw"
f <- system.file("sampleData", "Xdata.txt", package="CGEN")
pheno.list <- list(file=f, id.var="id", file.type=3, delimiter="\t",
              response.var="case.control", strata.var="ethnic.group",
              main.vars=c("oral.years", "n.children"),
              int.vars="oral.years")


###################################################
### chunk number 10: options list
###################################################
#line 91 "vignette.Rnw"
out.file <- "snp.scan.logistic.output.file_h5jb47j.txt"
op <- list(out.file=out.file)


###################################################
### chunk number 11: snp.scan.logistic
###################################################
#line 101 "vignette.Rnw"
ret <- snp.scan.logistic(snp.list, pheno.list, op=op)


###################################################
### chunk number 12: read data
###################################################
#line 106 "vignette.Rnw"
x <- read.table(out.file, sep="\t", header=TRUE)
x[1:5, ]


###################################################
### chunk number 13: qq plot
###################################################
#line 112 "vignette.Rnw"
ret <- QQ.plot(x[, "UML.omnibus.pvalue"])


###################################################
### chunk number 14: system.file
###################################################
#line 118 "vignette.Rnw"
map <- system.file("sampleData", "LocusMapData.txt", package="CGEN")


###################################################
### chunk number 15: locus map list
###################################################
#line 123 "vignette.Rnw"
read.table(map, sep="\t", header=1, nrows=5)
lmap.list <- list(file=map, file.type=3, header=1, delimiter="\t",
                 snp.var="SNP", chrm.var="CHROMOSOME", loc.var="LOCATION")


###################################################
### chunk number 16: plot setup
###################################################
#line 131 "vignette.Rnw"
plot.vars <- c("UML.omnibus.pvalue", "CML.omnibus.pvalue", "EB.omnibus.pvalue")
op <- list(pch=c(21, 22, 23), alt.colors=1)
#plot.new()


###################################################
### chunk number 17: chromosome.plot
###################################################
#line 138 "vignette.Rnw"
ret <- chromosome.plot(out.file, plot.vars, lmap.list, op=op)


###################################################
### chunk number 18: top hits
###################################################
#line 143 "vignette.Rnw"
temp <- sort(x[, "UML.omnibus.pvalue"], index.return=TRUE)$ix
topHits <- x[temp, ][1:10,]
topHits


###################################################
### chunk number 19: print table
###################################################
#line 156 "vignette.Rnw"
table(Xdata$case.control, Xdata$ethnic.group)


###################################################
### chunk number 20: getMatchedSets
###################################################
#line 164 "vignette.Rnw"
library("cluster")
size <- ifelse(Xdata$ethnic.group == 3, 3, 4)
d <- daisy(Xdata[,c("age.group_1","gynSurgery.history","BRCA.history")])
mx <- getMatchedSets(d, CC=TRUE, NN=TRUE, ccs.var = Xdata$case.control, 
	  strata.var = Xdata$ethnic.group, size = size, fixed = FALSE)


###################################################
### chunk number 21: Xdata
###################################################
#line 175 "vignette.Rnw"
mx$CC[1:10]
mx$tblCC
Xdata <- cbind(Xdata, CCStrat = mx$CC, NNStrat = mx$NN)
Xdata[1:5,]


###################################################
### chunk number 22: snp.matched
###################################################
#line 183 "vignette.Rnw"

intVars <- ~ oral.years + n.children
snpVars <- ~ BRCA.status
fit <- snp.matched(Xdata, "case.control", snp.vars=snpVars,
                     main.vars=intVars, int.vars=intVars, 
                     cc.var="CCStrat", nn.var="NNStrat") 


###################################################
### chunk number 23: summary table 2
###################################################
#line 193 "vignette.Rnw"
getSummary(fit, method = c("CLR", "CCL"))


###################################################
### chunk number 24: Wald test 2
###################################################
#line 198 "vignette.Rnw"
getWaldTest(fit$HCL, c( "BRCA.status" , "BRCA.status:oral.years" , "BRCA.status:n.children"))


###################################################
### chunk number 25: sessionInfo
###################################################
#line 203 "vignette.Rnw"
sessionInfo()


