###################################################
### chunk number 1: 
###################################################
#line 48 "Tutorial.Rnw"
options(width=60)
ps.options(family="sans")


###################################################
### chunk number 2: 
###################################################
#line 53 "Tutorial.Rnw"
library(BioNet)
library(DLBCL)
data(dataLym)
data(interactome)


###################################################
### chunk number 3: 
###################################################
#line 61 "Tutorial.Rnw"
pvals <- cbind(t=dataLym$t.pval, s=dataLym$s.pval)
rownames(pvals) <- dataLym$label
pval <- aggrPvals(pvals, order=2, plot=FALSE)


###################################################
### chunk number 4: 
###################################################
#line 68 "Tutorial.Rnw"
subnet <- subNetwork(dataLym$label, interactome)
subnet <- rmSelfLoops(subnet)
subnet


###################################################
### chunk number 5: 
###################################################
#line 77 "Tutorial.Rnw"
fb <- fitBumModel(pval, plot=FALSE)
scores <- scoreNodes(subnet, fb, fdr=0.001)


###################################################
### chunk number 6: 
###################################################
#line 86 "Tutorial.Rnw"
module <- runFastHeinz(subnet, scores)
logFC <- dataLym$diff
names(logFC) <- dataLym$label


###################################################
### chunk number 7: 
###################################################
#line 96 "Tutorial.Rnw"
plotModule(module, scores=scores, diff.expr=logFC)


###################################################
### chunk number 8: 
###################################################
#line 152 "Tutorial.Rnw"
library(BioNet)
library(DLBCL)
data(exprLym)
data(interactome)


###################################################
### chunk number 9: 
###################################################
#line 164 "Tutorial.Rnw"
exprLym


###################################################
### chunk number 10: 
###################################################
#line 171 "Tutorial.Rnw"
interactome


###################################################
### chunk number 11: 
###################################################
#line 179 "Tutorial.Rnw"
network <- subNetwork(featureNames(exprLym), interactome)
network


###################################################
### chunk number 12: 
###################################################
#line 186 "Tutorial.Rnw"
network <- largestComp(network)
network


###################################################
### chunk number 13: 
###################################################
#line 198 "Tutorial.Rnw"
library(genefilter)
library(impute)
expressions <- impute.knn(exprs(exprLym))$data
t.test <- rowttests(expressions, fac=exprLym$Subgroup)    


###################################################
### chunk number 14: 
###################################################
#line 205 "Tutorial.Rnw"
t.test[1:10, ]


###################################################
### chunk number 15: 
###################################################
#line 213 "Tutorial.Rnw"
library(xtable)
top.table <- xtable(t.test[1:10,], display=c("s", "f", "f", "f"))
print(top.table, floating=FALSE)                                    


###################################################
### chunk number 16: 
###################################################
#line 226 "Tutorial.Rnw"
data(dataLym)
ttest.pval <- t.test[, "p.value"]
surv.pval <- dataLym$s.pval
names(surv.pval) <- dataLym$label
pvals <- cbind(ttest.pval, surv.pval)


###################################################
### chunk number 17: 
###################################################
#line 240 "Tutorial.Rnw"
pval <- aggrPvals(pvals, order=2, plot=FALSE)


###################################################
### chunk number 18: 
###################################################
#line 248 "Tutorial.Rnw"
fb <- fitBumModel(pval, plot=FALSE)
fb   


###################################################
### chunk number 19: 
###################################################
#line 253 "Tutorial.Rnw"
dev.new(width=13, height=7)
par(mfrow=c(1,2))
hist(fb)
plot(fb)

dev.off()


###################################################
### chunk number 20: 
###################################################
#line 274 "Tutorial.Rnw"
plotLLSurface(pval, fb)


###################################################
### chunk number 21: 
###################################################
#line 284 "Tutorial.Rnw"
scores <- scoreNodes(network=network, fb=fb, fdr=0.001)


###################################################
### chunk number 22: 
###################################################
#line 292 "Tutorial.Rnw"
network <- rmSelfLoops(network)                                                                                                     
writeHeinzEdges(network=network, file="lymphoma_edges_001", use.score=FALSE)
writeHeinzNodes(network=network, file="lymphoma_nodes_001", node.scores = scores)


###################################################
### chunk number 23: 
###################################################
#line 312 "Tutorial.Rnw"
datadir <- file.path(.path.package("BioNet"), "extdata") 
dir(datadir)


###################################################
### chunk number 24: 
###################################################
#line 320 "Tutorial.Rnw"
module <- readHeinzGraph(node.file=file.path(datadir, "lymphoma_nodes_001.txt.0.hnz"), network=network)
diff <- t.test[, "dm"]
names(diff) <- rownames(t.test) 


###################################################
### chunk number 25: 
###################################################
#line 326 "Tutorial.Rnw"
plotModule(module, diff.expr=diff, scores=scores)


###################################################
### chunk number 26: 
###################################################
#line 349 "Tutorial.Rnw"
sum(scores[nodes(module)])
sum(scores[nodes(module)]>0)
sum(scores[nodes(module)]<0)


###################################################
### chunk number 27: 
###################################################
#line 373 "Tutorial.Rnw"
library(BioNet)
library(DLBCL)
library(ALL)
data(ALL)
data(interactome)


###################################################
### chunk number 28: 
###################################################
#line 385 "Tutorial.Rnw"
ALL


###################################################
### chunk number 29: 
###################################################
#line 394 "Tutorial.Rnw"
interactome


###################################################
### chunk number 30: 
###################################################
#line 405 "Tutorial.Rnw"
mapped.eset = mapByVar(ALL, network=interactome, attr="geneID")
mapped.eset[1:5,1:5]


###################################################
### chunk number 31: 
###################################################
#line 412 "Tutorial.Rnw"
length(intersect(rownames(mapped.eset), nodes(interactome)))


###################################################
### chunk number 32: 
###################################################
#line 422 "Tutorial.Rnw"
network = subNetwork(rownames(mapped.eset), interactome)
network
network <- largestComp(network)
network <- rmSelfLoops(network)
network


###################################################
### chunk number 33: 
###################################################
#line 438 "Tutorial.Rnw"
library(limma)
design= model.matrix(~ -1+ factor(c(substr(unlist(ALL$BT), 0, 1))))
colnames(design)= c("B", "T")
contrast.matrix <- makeContrasts(B-T, levels=design)
contrast.matrix 
fit <- lmFit(mapped.eset, design)
fit2 <- contrasts.fit(fit, contrast.matrix)
fit2 <- eBayes(fit2)


###################################################
### chunk number 34: 
###################################################
#line 451 "Tutorial.Rnw"
pval = fit2$p.value[,1]                                


###################################################
### chunk number 35: 
###################################################
#line 463 "Tutorial.Rnw"
fb <- fitBumModel(pval, plot=FALSE)
fb


###################################################
### chunk number 36: 
###################################################
#line 468 "Tutorial.Rnw"
dev.new(width=13, height=7)
par(mfrow=c(1,2))
hist(fb)
plot(fb)


###################################################
### chunk number 37: 
###################################################
#line 484 "Tutorial.Rnw"
scores <- scoreNodes(network=network, fb=fb, fdr=1e-14)


###################################################
### chunk number 38: 
###################################################
#line 491 "Tutorial.Rnw"
writeHeinzEdges(network=network, file="ALL_edges_001", use.score=FALSE)
writeHeinzNodes(network=network, file="ALL_nodes_001", node.scores = scores)


###################################################
### chunk number 39: 
###################################################
#line 512 "Tutorial.Rnw"
datadir <- file.path(.path.package("BioNet"), "extdata") 
module <- readHeinzGraph(node.file=file.path(datadir, "ALL_nodes_001.txt.0.hnz"), network=network)


###################################################
### chunk number 40: 
###################################################
#line 519 "Tutorial.Rnw"
nodeDataDefaults(module, attr="diff") <- ""
nodeData(module, n=nodes(module), attr="diff") <- fit2$coefficients[nodes(module),1]
nodeDataDefaults(module, attr="score") <- ""
nodeData(module, n=nodes(module), attr="score") <- scores[nodes(module)]
nodeData(module)[1]


###################################################
### chunk number 41: 
###################################################
#line 530 "Tutorial.Rnw"
saveNetwork(module, file="ALL_module", type="XGMML")


