###################################################
### chunk number 1: data
###################################################
#line 157 "AgiMicroRna.Rnw"
library("AgiMicroRna")
data(targets.micro)
print(targets.micro)


###################################################
### chunk number 2: data
###################################################
#line 229 "AgiMicroRna.Rnw"
data(dd.micro)
class(dd.micro)
dim(dd.micro)


###################################################
### chunk number 3: 
###################################################
#line 238 "AgiMicroRna.Rnw"
print(names(dd.micro))


###################################################
### chunk number 4: qcPlots
###################################################
#line 362 "AgiMicroRna.Rnw"
qcPlots(dd.micro,offset=5,
        MeanSignal=TRUE,
        ProcessedSignal=FALSE,
        TotalProbeSignal=FALSE,
        TotalGeneSignal=FALSE,
        BGMedianSignal=FALSE,
        BGUsed=FALSE,
        targets.micro)



###################################################
### chunk number 5: BoxPlot
###################################################
#line 382 "AgiMicroRna.Rnw"
boxplotMicroRna(log2(dd.micro$meanS),
	maintitle='log2 Mean Signal',
	colorfill= 'orange')


###################################################
### chunk number 6: plotDensity
###################################################
#line 391 "AgiMicroRna.Rnw"
plotDensityMicroRna(log2(dd.micro$meanS),
	maintitle='log2 Mean Signal')


###################################################
### chunk number 7: MA
###################################################
#line 400 "AgiMicroRna.Rnw"
ddaux=dd.micro
ddaux$G=log2(dd.micro$meanS)
mvaMicroRna(ddaux,
	maintitle='log2 Mean Signal',
	verbose=FALSE)
rm(ddaux)



###################################################
### chunk number 8: RLE
###################################################
#line 414 "AgiMicroRna.Rnw"
RleMicroRna(log2(dd.micro$meanS),
	maintitle='log2 Mean Signal - RLE')


###################################################
### chunk number 9: hclust
###################################################
#line 423 "AgiMicroRna.Rnw"
hierclusMicroRna(log2(dd.micro$meanS),targets.micro$GErep,
		methdis="euclidean",
                methclu="complete",
		sel=TRUE,100)


###################################################
### chunk number 10: cvArray
###################################################
#line 452 "AgiMicroRna.Rnw"
cvArray(dd.micro,
        "MeanSignal",
        targets.micro,
	verbose=TRUE)



###################################################
### chunk number 11: tgsMicroRna
###################################################
#line 485 "AgiMicroRna.Rnw"
ddTGS=tgsMicroRna(dd.micro,
    half=TRUE,
    makePLOT=FALSE,
    verbose=FALSE)



###################################################
### chunk number 12: tgsNormalization
###################################################
#line 518 "AgiMicroRna.Rnw"
ddNORM=tgsNormalization(ddTGS,
                "quantile",
                makePLOTpre=FALSE,
                makePLOTpost=FALSE,
                targets.micro,
		verbose=TRUE)


###################################################
### chunk number 13: rmaMicroRna eval=FALSE
###################################################
## #line 559 "AgiMicroRna.Rnw"
## ddTGS.rma=rmaMicroRna(dd.micro,
## 		normalize=TRUE,
## 		background=TRUE)
## 


###################################################
### chunk number 14: filterMicroRna
###################################################
#line 630 "AgiMicroRna.Rnw"

ddPROC=filterMicroRna(ddNORM,
                    dd.micro,
                    control=TRUE,
                    IsGeneDetected=TRUE,
                    wellaboveNEG=FALSE,
                    limIsGeneDetected=75,
                    limNEG=25,
                    makePLOT=FALSE,
                    targets.micro,
		    verbose=TRUE,
                    writeout=FALSE)


###################################################
### chunk number 15: esetMicroRna
###################################################
#line 651 "AgiMicroRna.Rnw"
esetPROC=esetMicroRna(ddPROC,
          targets.micro,
          makePLOT=FALSE,
	  verbose=TRUE)


###################################################
### chunk number 16: writeEset eval=FALSE
###################################################
## #line 663 "AgiMicroRna.Rnw"
## writeEset(esetPROC,
##             ddPROC,
##             targets.micro,
## 	    verbose=TRUE)


###################################################
### chunk number 17: 
###################################################
#line 696 "AgiMicroRna.Rnw"
levels.treatment=levels(factor(targets.micro$Treatment))
        treatment=factor(as.character(targets.micro$Treatment),
                levels=levels.treatment)



###################################################
### chunk number 18: 
###################################################
#line 702 "AgiMicroRna.Rnw"
levels.subject=levels(factor(targets.micro$Subject))
        subject=factor(as.character(targets.micro$Subject),
                levels=levels.subject)


###################################################
### chunk number 19: 
###################################################
#line 726 "AgiMicroRna.Rnw"
design=model.matrix(~ -1 + treatment + subject)
print(design)


###################################################
### chunk number 20: 
###################################################
#line 735 "AgiMicroRna.Rnw"
fit=lmFit(esetPROC,design)
names(fit)
print(head(fit$coeff))


###################################################
### chunk number 21: 
###################################################
#line 744 "AgiMicroRna.Rnw"
CM=cbind(MSC_AvsMSC_B=c(1,-1,0,0),
        MSC_AvsMSC_C=c(1,0,-1,0))
print(CM)


###################################################
### chunk number 22: 
###################################################
#line 754 "AgiMicroRna.Rnw"
fit2=contrasts.fit(fit,CM)
names(fit2)
print(head(fit2$coeff))


###################################################
### chunk number 23: 
###################################################
#line 763 "AgiMicroRna.Rnw"
fit2=eBayes(fit2)
names(fit2)


###################################################
### chunk number 24: basicLimma eval=FALSE
###################################################
## #line 777 "AgiMicroRna.Rnw"
## fit2=basicLimma(esetPROC,design,CM,verbose=TRUE)


###################################################
### chunk number 25: getDecideTests
###################################################
#line 794 "AgiMicroRna.Rnw"
DE=getDecideTests(fit2,
        DEmethod="separate",
        MTestmethod="BH",
        PVcut=0.10,
	verbose=TRUE)


###################################################
### chunk number 26: pvalHistogram eval=FALSE
###################################################
## #line 810 "AgiMicroRna.Rnw"
## pvalHistogram(fit2,
##         DE,
##         PVcut=0.10,
##         DEmethod="separate",
##         MTestmethod="BH",
##         CM,
## 	verbose=TRUE)


###################################################
### chunk number 27: significantMicroRna eval=FALSE
###################################################
## #line 829 "AgiMicroRna.Rnw"
## significantMicroRna(esetPROC,
##         ddPROC,
##         targets.micro,
##         fit2,
##         CM,
##         DE,
##         DEmethod="separate",
##         MTestmethod="BH",
##         PVcut=0.10,
##         Mcut=0,
## 	verbose=TRUE)


