###################################################
### chunk number 1: LibraryPreload
###################################################
#line 53 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpVu9rGd/R.INSTALL219acaa/xcms/inst/doc/xcmsPreprocess.Rnw"
library(multtest)
library(xcms)
library(faahKO)


###################################################
### chunk number 2: RawFiles
###################################################
#line 110 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpVu9rGd/R.INSTALL219acaa/xcms/inst/doc/xcmsPreprocess.Rnw"
cdfpath <- system.file("cdf", package = "faahKO")
list.files(cdfpath, recursive = TRUE)


###################################################
### chunk number 3: PeakIdentification
###################################################
#line 137 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpVu9rGd/R.INSTALL219acaa/xcms/inst/doc/xcmsPreprocess.Rnw"
library(xcms)
cdffiles <- list.files(cdfpath, recursive = TRUE, full.names = TRUE)
xset <- xcmsSet(cdffiles)
#xset <- faahko
xset


###################################################
### chunk number 4: PeakMatching1
###################################################
#line 254 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpVu9rGd/R.INSTALL219acaa/xcms/inst/doc/xcmsPreprocess.Rnw"
xset <- group(xset)


###################################################
### chunk number 5: RTCorrection
###################################################
#line 302 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpVu9rGd/R.INSTALL219acaa/xcms/inst/doc/xcmsPreprocess.Rnw"
xset2 <- retcor(xset, family = "symmetric", plottype = "mdevden")


###################################################
### chunk number 6: PeakMatching2
###################################################
#line 333 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpVu9rGd/R.INSTALL219acaa/xcms/inst/doc/xcmsPreprocess.Rnw"
xset2 <- group(xset2, bw = 10)


###################################################
### chunk number 7: PeakFillIn
###################################################
#line 349 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpVu9rGd/R.INSTALL219acaa/xcms/inst/doc/xcmsPreprocess.Rnw"
xset3 <- fillPeaks(xset2)
xset3


###################################################
### chunk number 8: AnalysisVisualize
###################################################
#line 385 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpVu9rGd/R.INSTALL219acaa/xcms/inst/doc/xcmsPreprocess.Rnw"
reporttab <- diffreport(xset3, "WT", "KO", "example", 10, 
                        metlin = 0.15, h=480, w=640)
reporttab[1:4,]


###################################################
### chunk number 9: URL1
###################################################
#line 403 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpVu9rGd/R.INSTALL219acaa/xcms/inst/doc/xcmsPreprocess.Rnw"
cat("\\url{", as.character(reporttab[1,"metlin"]), "}", sep = "")


###################################################
### chunk number 10: URL2
###################################################
#line 409 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpVu9rGd/R.INSTALL219acaa/xcms/inst/doc/xcmsPreprocess.Rnw"
cat("\\url{", as.character(reporttab[3,"metlin"]), "}", sep = "")


###################################################
### chunk number 11: PeakSelect
###################################################
#line 424 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpVu9rGd/R.INSTALL219acaa/xcms/inst/doc/xcmsPreprocess.Rnw"
gt <- groups(xset3)
colnames(gt)
groupidx1 <- which(gt[,"rtmed"] > 2600 & gt[,"rtmed"] < 2700 & gt[,"npeaks"] == 12)[1]
groupidx2 <- which(gt[,"rtmed"] > 3600 & gt[,"rtmed"] < 3700 & gt[,"npeaks"] == 12)[1]
eiccor <- getEIC(xset3, groupidx = c(groupidx1, groupidx2))
eicraw <- getEIC(xset3, groupidx = c(groupidx1, groupidx2), rt = "raw")


###################################################
### chunk number 12: EICRaw1
###################################################
#line 433 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpVu9rGd/R.INSTALL219acaa/xcms/inst/doc/xcmsPreprocess.Rnw"
plot(eicraw, xset3, groupidx = 1)


###################################################
### chunk number 13: EICRaw2
###################################################
#line 437 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpVu9rGd/R.INSTALL219acaa/xcms/inst/doc/xcmsPreprocess.Rnw"
plot(eicraw, xset3, groupidx = 2)


###################################################
### chunk number 14: EICCor1
###################################################
#line 441 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpVu9rGd/R.INSTALL219acaa/xcms/inst/doc/xcmsPreprocess.Rnw"
plot(eiccor, xset3, groupidx = 1)


###################################################
### chunk number 15: EICCor2
###################################################
#line 445 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpVu9rGd/R.INSTALL219acaa/xcms/inst/doc/xcmsPreprocess.Rnw"
plot(eiccor, xset3, groupidx = 2)


###################################################
### chunk number 16: warnings
###################################################
#line 449 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpVu9rGd/R.INSTALL219acaa/xcms/inst/doc/xcmsPreprocess.Rnw"
cat("These are the warning")
warnings()


