###################################################
### chunk number 1: init
###################################################
#line 62 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpajagWM/R.INSTALL3ee753d/snpMatrix/inst/doc/imputation-vignette.Rnw"
library(snpMatrix)
library(hexbin)
data(for.exercise)


###################################################
### chunk number 2: select
###################################################
#line 73 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpajagWM/R.INSTALL3ee753d/snpMatrix/inst/doc/imputation-vignette.Rnw"
training <- sample(1000, 200)
in.target<- seq(1, ncol(snps.10),2) 
missing <- snps.10[training, -in.target]
present <- snps.10[training, in.target] 
missing 
present 


###################################################
### chunk number 3: target
###################################################
#line 85 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpajagWM/R.INSTALL3ee753d/snpMatrix/inst/doc/imputation-vignette.Rnw"
target <- snps.10[-training, in.target]
target


###################################################
### chunk number 4: 
###################################################
#line 92 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpajagWM/R.INSTALL3ee753d/snpMatrix/inst/doc/imputation-vignette.Rnw"
lost <- snps.10[-training, -in.target]
lost


###################################################
### chunk number 5: positions
###################################################
#line 100 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpajagWM/R.INSTALL3ee753d/snpMatrix/inst/doc/imputation-vignette.Rnw"
pos.miss <- snp.support$position[-in.target]
pos.pres <- snp.support$position[in.target]


###################################################
### chunk number 6: rules
###################################################
#line 115 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpajagWM/R.INSTALL3ee753d/snpMatrix/inst/doc/imputation-vignette.Rnw"
rules <- snp.imputation(present, missing, pos.pres, pos.miss)


###################################################
### chunk number 7: rule1
###################################################
#line 140 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpajagWM/R.INSTALL3ee753d/snpMatrix/inst/doc/imputation-vignette.Rnw"
rules[1:10]


###################################################
### chunk number 8: rule2
###################################################
#line 145 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpajagWM/R.INSTALL3ee753d/snpMatrix/inst/doc/imputation-vignette.Rnw"
rules[c('rs7898275', 'rs9419496')]


###################################################
### chunk number 9: summary
###################################################
#line 154 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpajagWM/R.INSTALL3ee753d/snpMatrix/inst/doc/imputation-vignette.Rnw"
summary(rules)


###################################################
### chunk number 10: ruleplot
###################################################
#line 165 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpajagWM/R.INSTALL3ee753d/snpMatrix/inst/doc/imputation-vignette.Rnw"
plot(rules)


###################################################
### chunk number 11: imptest
###################################################
#line 174 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpajagWM/R.INSTALL3ee753d/snpMatrix/inst/doc/imputation-vignette.Rnw"
imp <- single.snp.tests(cc, stratum, data=subject.support,
                        snp.data=target, rules=rules)


###################################################
### chunk number 12: realtest
###################################################
#line 186 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpajagWM/R.INSTALL3ee753d/snpMatrix/inst/doc/imputation-vignette.Rnw"
obs <- single.snp.tests(cc, stratum, data=subject.support, snp.data=lost)


###################################################
### chunk number 13: compare
###################################################
#line 194 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpajagWM/R.INSTALL3ee753d/snpMatrix/inst/doc/imputation-vignette.Rnw"
logP.imp <- -log10(p.value(imp, df=1))
logP.obs <- -log10(p.value(obs, df=1))
hb <- hexbin(logP.obs, logP.imp, xbin=50)
sp <- plot(hb)
hexVP.abline(sp$plot.vp, 0, 1, col="black")


###################################################
### chunk number 14: best
###################################################
#line 207 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpajagWM/R.INSTALL3ee753d/snpMatrix/inst/doc/imputation-vignette.Rnw"
use <- imputation.r2(rules)>0.9
hb <- hexbin(logP.obs[use], logP.imp[use], xbin=50)
sp <- plot(hb)
hexVP.abline(sp$plot.vp, 0, 1, col="black")


###################################################
### chunk number 15: rsqmaf
###################################################
#line 219 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpajagWM/R.INSTALL3ee753d/snpMatrix/inst/doc/imputation-vignette.Rnw"
hb <- hexbin(imputation.maf(rules), imputation.r2(rules), xbin=50)
sp <- plot(hb)


###################################################
### chunk number 16: imptest-rhs
###################################################
#line 233 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpajagWM/R.INSTALL3ee753d/snpMatrix/inst/doc/imputation-vignette.Rnw"
imp2 <- snp.rhs.tests(cc~strata(stratum), family="binomial", 
                      data=subject.support, snp.data=target, rules=rules)
logP.imp2 <- -log10(p.value(imp2))
hb <- hexbin(logP.obs, logP.imp2, xbin=50)
sp <- plot(hb)
hexVP.abline(sp$plot.vp, 0, 1, col="black")


###################################################
### chunk number 17: class-imp-obs
###################################################
#line 268 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpajagWM/R.INSTALL3ee753d/snpMatrix/inst/doc/imputation-vignette.Rnw"
class(imp)


###################################################
### chunk number 18: save-scores
###################################################
#line 275 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpajagWM/R.INSTALL3ee753d/snpMatrix/inst/doc/imputation-vignette.Rnw"
obs <- single.snp.tests(cc, stratum, data=subject.support, snp.data=missing, 
                        score=TRUE)
imp <- single.snp.tests(cc, stratum, data=subject.support,
                        snp.data=target, rules=rules, score=TRUE)


###################################################
### chunk number 19: 
###################################################
#line 282 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpajagWM/R.INSTALL3ee753d/snpMatrix/inst/doc/imputation-vignette.Rnw"
class(obs)
class(imp)


###################################################
### chunk number 20: pool
###################################################
#line 295 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpajagWM/R.INSTALL3ee753d/snpMatrix/inst/doc/imputation-vignette.Rnw"
both <- pool(obs, imp)
class(both)
both[1:5]


###################################################
### chunk number 21: pool-score
###################################################
#line 303 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpajagWM/R.INSTALL3ee753d/snpMatrix/inst/doc/imputation-vignette.Rnw"
both <- pool(obs, imp, score=TRUE)
class(both)


###################################################
### chunk number 22: sign
###################################################
#line 312 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpajagWM/R.INSTALL3ee753d/snpMatrix/inst/doc/imputation-vignette.Rnw"
table(effect.sign(obs))


###################################################
### chunk number 23: switch
###################################################
#line 336 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpajagWM/R.INSTALL3ee753d/snpMatrix/inst/doc/imputation-vignette.Rnw"
effect.sign(obs)[1:6]
sw.obs <- switch.alleles(obs, c("rs7093061", "rs7475011"))
class(sw.obs)
effect.sign(sw.obs)[1:6]


