###################################################
### chunk number 1: initialize
###################################################
#line 25 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
options(width=70)


###################################################
### chunk number 2: rtl-init
###################################################
#line 97 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
library("humanStemCell")
data(fhesc)
library("genefilter")
filtFhesc <- nsFilter(fhesc)[[1]]
library("limma")
design <- model.matrix(~filtFhesc$Diff) 
hesclim <- lmFit(filtFhesc, design) 
hesceb <- eBayes(hesclim) 
tab <- topTable(hesceb, coef = 2, adjust.method = "BH", n = 7676) 
tab2 <- tab[(tab$logFC > 1) & (tab$adj.P.Val < 0.01),]
affyIDs <- tab2$ID
library("microRNA")
data(hsTargets)
library("hgu133plus2.db")
entrezIDs <- mappedRkeys(hgu133plus2ENTREZID[affyIDs])
library("org.Hs.eg.db")
mappedEntrezIDs <- entrezIDs[entrezIDs %in% mappedkeys(org.Hs.egENSEMBLTRANS)]
ensemblIDs <- mappedRkeys(org.Hs.egENSEMBLTRANS[mappedEntrezIDs])
targetMatches <- match(ensemblIDs, hsTargets$target, 0)
## same as data(targets)
targets <- hsTargets[targetMatches,]


###################################################
### chunk number 3: rtl-miRNA-track
###################################################
#line 125 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
library(rtracklayer)
library(GenomicRanges)
## call data(targets) if skipping first block
head(targets)
targetRanges <- IRanges(targets$start, targets$end)
targetTrack <- with(targets, 
                    GRangesForUCSCGenome("hg18", paste("chr", chrom, sep = ""), 
                                         targetRanges, strand, name, target))


###################################################
### chunk number 4: rtl-miRNA-track-seqinfo
###################################################
#line 144 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
genome(targetTrack)
head(seqlengths(targetTrack))


###################################################
### chunk number 5: feature-data-accessors
###################################################
#line 174 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
head(seqnames(targetTrack))
head(start(targetTrack))


###################################################
### chunk number 6: sol-1
###################################################
#line 188 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
head(strand(targetTrack))
head(width(targetTrack))
data.frame(chrom = as.factor(seqnames(targetTrack)), 
           start = start(targetTrack), end = end(targetTrack),
           strand = as.factor(strand(targetTrack)))


###################################################
### chunk number 7: subset-features
###################################################
#line 206 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
## get the first 10 targets
first10 <- targetTrack[1:10]
## get pos strand targets
posTargets <- targetTrack[strand(targetTrack) == "+"]
## get the targets on chr1
chr1Targets <- targetTrack[seqnames(targetTrack) == "chr1"]


###################################################
### chunk number 8: sol-2
###################################################
#line 223 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
negChr2Targets <- targetTrack[strand(targetTrack) == "-" & 
                              seqnames(targetTrack) == "chr2"]


###################################################
### chunk number 9: export eval=FALSE
###################################################
## #line 245 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
## export(targetTrack, "targets.bed")


###################################################
### chunk number 10: import eval=FALSE
###################################################
## #line 254 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
## restoredTrack <- import("targets.bed")


###################################################
### chunk number 11: import-gr eval=FALSE
###################################################
## #line 261 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
## restoredTrack <- import("targets.bed", asRangedData = FALSE)


###################################################
### chunk number 12: sol-3
###################################################
#line 279 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
export(targetTrack, "targets.gff")
targetGff <- import("targets.gff")
targetChar <- export(targetTrack, format = "gff1")


###################################################
### chunk number 13: browserSession eval=FALSE
###################################################
## #line 302 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
## session <- browserSession("UCSC")


###################################################
### chunk number 14: genomeBrowsers
###################################################
#line 308 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
genomeBrowsers()


###################################################
### chunk number 15: layTrack eval=FALSE
###################################################
## #line 317 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
## track(session, "targets") <- targetTrack


###################################################
### chunk number 16: sol-4 eval=FALSE
###################################################
## #line 334 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
## session$target100 <- targetTrack[1:100]


###################################################
### chunk number 17: take-subset
###################################################
#line 348 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
subTargetTrack <- targetTrack[1] # get first feature


###################################################
### chunk number 18: view-subset eval=FALSE
###################################################
## #line 358 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
## view <- browserView(session, subTargetTrack * -10, pack = "targets")


###################################################
### chunk number 19: view-subset-multi eval=FALSE
###################################################
## #line 363 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
## view <- browserView(session, targetTrack[1:5] * -10, pack = "targets")


###################################################
### chunk number 20: sol-6 eval=FALSE
###################################################
## #line 377 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
## viewOut <- browserView(session, range(view) * -2)
## viewFull <- browserView(session, full = "targets")


###################################################
### chunk number 21: browseGenome eval=FALSE
###################################################
## #line 389 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
## browseGenome(targetTrack, range = subTargetTrack * -10)


###################################################
### chunk number 22: browseGenome-simple eval=FALSE
###################################################
## #line 394 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
## browseGenome(subTargetTrack)


###################################################
### chunk number 23: get-track-names eval=FALSE
###################################################
## #line 404 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
## loaded_tracks <- trackNames(session)


###################################################
### chunk number 24: get-track-data eval=FALSE
###################################################
## #line 411 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
## subTargetTrack <- track(session, "targets")


###################################################
### chunk number 25: get-track-segment eval=FALSE
###################################################
## #line 424 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
## chr1Targets <- track(session, "targets", chr1Targets)


###################################################
### chunk number 26: sol-7 eval=FALSE
###################################################
## #line 435 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
## region <- range(subTargetTrack) + 500
## targetSNP <- track(session, "snp130", region)
## as.data.frame(targetSNP)
## targetGene <- track(session, "knownGene", region)
## as.data.frame(targetGene)


###################################################
### chunk number 27: genomeSegment-view eval=FALSE
###################################################
## #line 453 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
## segment <- range(view)


###################################################
### chunk number 28: tracks-view eval=FALSE
###################################################
## #line 458 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
## visible_tracks <- trackNames(view)
## trackNames(view) <- visible_tracks


###################################################
### chunk number 29: track-modes-view eval=FALSE
###################################################
## #line 465 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
## modes <- ucscTrackModes(view)


###################################################
### chunk number 30: set-track-modes eval=FALSE
###################################################
## #line 473 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
## modes["targets"]
## modes["targets"] <- "full"
## ucscTrackModes(view) <- modes


###################################################
### chunk number 31: browserViews eval=FALSE
###################################################
## #line 482 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
## views <- browserViews(session)
## length(views)


###################################################
### chunk number 32: sol-8 eval=FALSE
###################################################
## #line 496 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
## viewTarget <- track(session, "targets", range(view))
## trackNames(view) <- c("snp130", "knownGene", "targets")
## ucscTrackModes(view)["knownGene"] <- "hide"


###################################################
### chunk number 33: load-snp
###################################################
#line 513 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
library(rtracklayer)
data(cpneTrack)


###################################################
### chunk number 34: datavals-accessor
###################################################
#line 527 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
head(score(cpneTrack))


###################################################
### chunk number 35: trackData
###################################################
#line 540 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
plot(start(cpneTrack), score(cpneTrack))


###################################################
### chunk number 36: layTrack-snp eval=FALSE
###################################################
## #line 555 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
## session <- browserSession()
## session$cpne <- cpneTrack


###################################################
### chunk number 37: browserView-snp eval=FALSE
###################################################
## #line 583 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
## view <- browserView(session, range(cpneTrack[1:5,]), full = "cpne")


###################################################
### chunk number 38: layTrack-snp2 eval=FALSE
###################################################
## #line 598 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
## track(session, "cpne2", autoScale = FALSE, yLineOnOff = TRUE, 
##       yLineMark = quantile(score(cpneTrack), .25)) <- cpneTrack
## view <- browserView(session, range(cpneTrack[1:5,]), full = "cpne2")


###################################################
### chunk number 39: search-nrsf
###################################################
#line 621 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
library(BSgenome.Hsapiens.UCSC.hg19)
nrsfHits <- matchPattern("TCAGCACCATGGACAG", Hsapiens[["chr1"]])
length(nrsfHits)  # number of hits


###################################################
### chunk number 40: track-nrsf
###################################################
#line 632 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
nrsfTrack <- GenomicData(nrsfHits, strand="+", chrom="chr1", genome = "hg19")


###################################################
### chunk number 41: browserView-nrsf eval=FALSE
###################################################
## #line 651 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
## session <- browseGenome(nrsfTrack, range = range(nrsfTrack[1,]) * -10)


###################################################
### chunk number 42: session-info
###################################################
#line 665 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmppJhX6g/R.INSTALL7e61ed8/rtracklayer/inst/doc/rtracklayer.Rnw"
  sessionInfo()


