###################################################
### chunk number 1: setup
###################################################
#line 36 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
library(Biobase)
library(annotate)
library(genefilter)
library(org.EcK12.eg.db)
library(graph)
library(qpgraph)


###################################################
### chunk number 2: setup
###################################################
#line 47 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
data(EcoliOxygen)
ls()


###################################################
### chunk number 3: setup
###################################################
#line 62 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
gds680.eset


###################################################
### chunk number 4: preprocessing
###################################################
#line 83 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
head(filtered.regulon6.1)


###################################################
### chunk number 5: preprocessing
###################################################
#line 90 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
knockoutsyms <- c("arcA","appY","oxyR","soxS","fnr")
rmap <- revmap(getAnnMap("SYMBOL", "org.EcK12.eg.db"))
knockoutEgIDs <- unlist(mget(knockoutsyms, rmap))
knockoutEgIDs


###################################################
### chunk number 6: preprocessing
###################################################
#line 99 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
mt <- match(filtered.regulon6.1[,"EgID_TF"], knockoutEgIDs)
cat("These 5 TFs are involved in",sum(!is.na(mt)),"TF-TG interactions\n")
genesO2net <- as.character(unique(as.vector(
              as.matrix(filtered.regulon6.1[!is.na(mt),c("EgID_TF","EgID_TG")]))))
cat("There are",length(genesO2net),"different genes in this subnetwork\n")


###################################################
### chunk number 7: preprocessing
###################################################
#line 108 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
IQRs <- apply(exprs(gds680.eset[genesO2net,]), 1, IQR)
largestIQRgenesO2net <- names(sort(IQRs,decreasing=TRUE)[1:100])


###################################################
### chunk number 8: preprocessing
###################################################
#line 115 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
dim(gds680.eset)
subset.gds680.eset <- gds680.eset[largestIQRgenesO2net,]
dim(subset.gds680.eset)
subset.gds680.eset


###################################################
### chunk number 9: preprocessing
###################################################
#line 125 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
mtTF <- match(filtered.regulon6.1[,"EgID_TF"],largestIQRgenesO2net)
mtTG <- match(filtered.regulon6.1[,"EgID_TG"],largestIQRgenesO2net)

cat(sprintf("The 100 genes are involved in %d RegulonDB interactions\n",
    sum(!is.na(mtTF) & !is.na(mtTG))))

subset.filtered.regulon6.1 <- filtered.regulon6.1[!is.na(mtTF) & !is.na(mtTG),]


###################################################
### chunk number 10: preprocessing
###################################################
#line 140 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
TFi <- match(subset.filtered.regulon6.1[,"EgID_TF"],
             featureNames(subset.gds680.eset))
TGi <- match(subset.filtered.regulon6.1[,"EgID_TG"],
             featureNames(subset.gds680.eset))

subset.filtered.regulon6.1 <- cbind(subset.filtered.regulon6.1,
                                    idx_TF=TFi, idx_TG=TGi)

p <- dim(subset.gds680.eset)["Features"]

subset.filtered.regulon6.1.I <- matrix(FALSE, nrow=p, ncol=p)
rownames(subset.filtered.regulon6.1.I) <- featureNames(subset.gds680.eset)
colnames(subset.filtered.regulon6.1.I) <- featureNames(subset.gds680.eset)

idxTFTG <- as.matrix(subset.filtered.regulon6.1[,c("idx_TF","idx_TG")])

subset.filtered.regulon6.1.I[idxTFTG] <-
   subset.filtered.regulon6.1.I[cbind(idxTFTG[,2],idxTFTG[,1])] <- TRUE


###################################################
### chunk number 11: getthenet
###################################################
#line 172 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
pcc.estimates <- qpPCC(subset.gds680.eset)


###################################################
### chunk number 12: getthenet
###################################################
#line 180 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
largestIQRgenesO2net_i <- match(largestIQRgenesO2net,
                                featureNames(subset.gds680.eset))
largestIQRgenesO2netTFs <- largestIQRgenesO2net[!is.na(
                           match(largestIQRgenesO2net,filtered.regulon6.1[,"EgID_TF"]))]
largestIQRgenesO2netTFs_i <- match(largestIQRgenesO2netTFs,
                                   featureNames(subset.gds680.eset))
TFsbyTGs <- as.matrix(expand.grid(largestIQRgenesO2netTFs_i,
                                  setdiff(largestIQRgenesO2net_i,largestIQRgenesO2netTFs_i)))
TFsbyTGs <- rbind(TFsbyTGs,t(combn(largestIQRgenesO2netTFs_i, 2)))
summary(abs(pcc.estimates$R[TFsbyTGs]))


###################################################
### chunk number 13: getthenet
###################################################
#line 197 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
regulonDBgenes <- as.character(unique(c(filtered.regulon6.1[, "EgID_TF"],
                                        filtered.regulon6.1[, "EgID_TG"])))
cat(sprintf("The RegulonDB transcriptional network involves %d genes",
            length(regulonDBgenes)))

pcc.allRegulonDB.estimates <- qpPCC(gds680.eset[regulonDBgenes,])

allTFs_i <- match(unique(filtered.regulon6.1[, "EgID_TF"]), regulonDBgenes)
allTFsbyTGs <- as.matrix(expand.grid(allTFs_i,
                                     setdiff(1:length(regulonDBgenes), allTFs_i)))
allTFsbyTGs <- rbind(allTFsbyTGs,t(combn(allTFs_i, 2)))
summary(abs(pcc.allRegulonDB.estimates$R[allTFsbyTGs]))


###################################################
### chunk number 14: getthenet
###################################################
#line 221 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
mt <- match(knockoutEgIDs,largestIQRgenesO2net)
unlist(mget(largestIQRgenesO2net[mt[!is.na(mt)]],org.EcK12.egSYMBOL))


###################################################
### chunk number 15: getthenet
###################################################
#line 228 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
maskRegulonTFTG <- subset.filtered.regulon6.1.I & upper.tri(subset.filtered.regulon6.1.I)
summary(abs(pcc.estimates$R[maskRegulonTFTG]))


###################################################
### chunk number 16: getthenet eval=FALSE
###################################################
## #line 242 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
## postscript(file="qpPCCdistbyTF.eps", onefile=FALSE, paper="a4",
##            pointsize=12, horizontal=FALSE, height=6, width=6)


###################################################
### chunk number 17: getthenet
###################################################
#line 247 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
par(mar=c(5,4,5,2))
pccsbyTF <- list()
for (TFi in subset.filtered.regulon6.1[,"idx_TF"])
  pccsbyTF[[featureNames(subset.gds680.eset)[TFi]]] <- abs(pcc.estimates$R[TFi, subset.filtered.regulon6.1.I[TFi,]])
bp <- boxplot(pccsbyTF,names=sprintf("%s",mget(names(pccsbyTF),org.EcK12.egSYMBOL)),
              ylab="Pearson correlation coefficient (PCC)",
              main=paste("Distribution of PCCs in each RegulonDB",
                         "regulatory module within the 100 genes data set", sep="\n"))
nint <- sprintf("(%d)",sapply(names(pccsbyTF), function(x)
                       sum(subset.filtered.regulon6.1.I[x,])))
mtext(nint, at=seq(bp$n), line=+2, side=1)
mtext("Transcription factor (# RegulonDB interactions)", side=1, line=+4)


###################################################
### chunk number 18: getthenet eval=FALSE
###################################################
## #line 261 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
## dev.off()


###################################################
### chunk number 19: getthenet
###################################################
#line 291 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
set.seed(123)


###################################################
### chunk number 20: getthenet
###################################################
#line 298 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
avgnrr.estimates <- qpAvgNrr(subset.gds680.eset,
                             pairup.i=largestIQRgenesO2netTFs,
                             pairup.j=largestIQRgenesO2net, verbose=FALSE)


###################################################
### chunk number 21: getthenet
###################################################
#line 320 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
pcc.prerec <- qpPrecisionRecall(abs(pcc.estimates$R), subset.filtered.regulon6.1.I,
                                decreasing=TRUE, pairup.i=largestIQRgenesO2netTFs,
                                pairup.j=largestIQRgenesO2net,
                                recallSteps=c(seq(0,0.1,0.01),seq(0.2,1,0.1)))


###################################################
### chunk number 22: getthenet
###################################################
#line 330 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
avgnrr.prerec <- qpPrecisionRecall(avgnrr.estimates, subset.filtered.regulon6.1.I,
                                   decreasing=FALSE,
                                   recallSteps=c(seq(0,0.1,0.01),seq(0.2,1,0.1)))


###################################################
### chunk number 23: getthenet
###################################################
#line 338 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
set.seed(123)
rndcor <- qpUnifRndAssociation(100, featureNames(subset.gds680.eset))
random.prerec <- qpPrecisionRecall(abs(rndcor), subset.filtered.regulon6.1.I,
                                   decreasing=TRUE, pairup.i=largestIQRgenesO2netTFs,
                                   pairup.j=largestIQRgenesO2net,
                                   recallSteps=c(seq(0,0.1,0.01),seq(0.2,1,0.1)))


###################################################
### chunk number 24: getthenet
###################################################
#line 353 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
f <- approxfun(pcc.prerec[,c("Recall","Precision")])
area <- integrate(f,0,1)$value
f <- approxfun(avgnrr.prerec[,c("Recall","Precision")])
area <- cbind(area, integrate(f,0,1)$value)
f <- approxfun(random.prerec[,c("Recall","Precision")])
area <- cbind(area, integrate(f,0,1)$value)
colnames(area) <- c("PCC", "avgNRR", "Random")
rownames(area) <- "AreaPrecisionRecall"
printCoefmat(area)


###################################################
### chunk number 25: getthenet eval=FALSE
###################################################
## #line 381 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
## postscript(file="qpPreRecComparison.eps", onefile=FALSE, paper="a4",
##            pointsize=12, horizontal=FALSE, height=6, width=6)


###################################################
### chunk number 26: getthenet
###################################################
#line 385 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
par(mai=c(.5,.5,1,.5),mar=c(5,4,7,2)+0.1)
plot(avgnrr.prerec[,c(1,2)], type="b", lty=1, pch=19, cex=0.65, lwd=4, col="red",
     xlim=c(0,0.1), ylim=c(0,1), axes=FALSE,
     xlab="Recall (% RegulonDB interactions)", ylab="Precision (%)")
axis(1, at=seq(0,1,0.01), labels=seq(0,100,1))
axis(2, at=seq(0,1,0.10), labels=seq(0,100,10))
axis(3, at=avgnrr.prerec[,"Recall"],
     labels=round(avgnrr.prerec[,"Recall"]*dim(subset.filtered.regulon6.1)[1],
                  digits=0))
title(main="Precision-recall comparison", line=+5)
lines(pcc.prerec[,c(1,2)], type="b", lty=1, pch=22, cex=0.65, lwd=4, col="blue")
lines(random.prerec[,c(1,2)], type="l", lty=2, lwd=4, col="black")
mtext("Recall (# RegulonDB interactions)", 3, line=+3)
legend(0.06, 1.0, c("qp-graph","PCC","Random"), col=c("red","blue","black"),
       lty=c(1,1,2), pch=c(19,22,-1), lwd=3, bg="white",pt.cex=0.85)


###################################################
### chunk number 27: getthenet eval=FALSE
###################################################
## #line 402 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
## dev.off()


###################################################
### chunk number 28: getthenet eval=FALSE
###################################################
## #line 405 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
## postscript(file="qpPreRecComparisonFullRecall.eps", onefile=FALSE, paper="a4",
##            pointsize=12, horizontal=FALSE, height=6, width=6)


###################################################
### chunk number 29: getthenet eval=FALSE
###################################################
## #line 409 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
## par(mai=c(.5,.5,1,.5),mar=c(5,4,7,2)+0.1)
## plot(avgnrr.prerec[,c(1,2)], type="b", lty=1, pch=19, cex=0.65, lwd=4, col="red",
##      xlim=c(0,1), ylim=c(0,1), axes=FALSE,
##      xlab="Recall (% RegulonDB interactions)", ylab="Precision (%)")
## axis(1, at=seq(0,1,0.10), labels=seq(0,100,10))
## axis(2, at=seq(0,1,0.10), labels=seq(0,100,10))
## axis(3, at=avgnrr.prerec[,"Recall"],
##      labels=round(avgnrr.prerec[,"Recall"]*dim(subset.filtered.regulon6.1)[1],
##                   digits=0))
## title(main="Precision-recall comparison", line=+5)
## lines(pcc.prerec[,c(1,2)], type="b", lty=1, pch=22, cex=0.65, lwd=4, col="blue")
## lines(random.prerec[,c(1,2)], type="l", lty=2, lwd=4, col="black")
## mtext("Recall (# RegulonDB interactions)", 3, line=+3)
## legend(0.6, 1.0, c("qp-graph","PCC","Random"), col=c("red","blue","black"),
##        lty=c(1,1,2), pch=c(19,22,-1), lwd=3, bg="white",pt.cex=0.85)


###################################################
### chunk number 30: getthenet eval=FALSE
###################################################
## #line 426 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
## dev.off()


###################################################
### chunk number 31: getthenet
###################################################
#line 452 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
thr <- qpPRscoreThreshold(avgnrr.prerec, level=0.5, recall.level=FALSE, max.score=0)
thr


###################################################
### chunk number 32: getthenet
###################################################
#line 460 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
g <- qpGraph(avgnrr.estimates, threshold=thr, return.type="graphNEL")
g


###################################################
### chunk number 33: getthenet
###################################################
#line 469 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
qpCliqueNumber(g, verbose=FALSE)


###################################################
### chunk number 34: getthenet
###################################################
#line 476 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
pac.estimates <- qpPAC(subset.gds680.eset, g, verbose=FALSE)


###################################################
### chunk number 35: getthenet
###################################################
#line 485 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
edL <- edges(g)[names(edges(g))[unlist(lapply(edges(g),length)) > 0]]
edM <- matrix(unlist(sapply(names(edL),
              function(x) t(cbind(x,edL[[x]])),USE.NAMES=FALSE)),
              ncol=2,byrow=TRUE)


###################################################
### chunk number 36: getthenet
###################################################
#line 493 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
edSymbols <- cbind(unlist(mget(edM[,1], org.EcK12.egSYMBOL)),
                   unlist(mget(edM[,2], org.EcK12.egSYMBOL)))
idxTF <- match(edM[,1], featureNames(subset.gds680.eset))
idxTG <- match(edM[,2], featureNames(subset.gds680.eset))
nrrs <- avgnrr.estimates[cbind(idxTF, idxTG)]
pacs.rho <- pac.estimates$R[cbind(idxTF, idxTG)]
pacs.pva <- pac.estimates$P[cbind(idxTF, idxTG)]
pccs.rho <- pcc.estimates$R[cbind(idxTF, idxTG)]
pccs.pva <- pcc.estimates$P[cbind(idxTF, idxTG)]

idxRegDB <- apply(edM,1,function(x) { 
                          regdbmask <-
                            apply(
                            cbind(match(subset.filtered.regulon6.1[,"EgID_TF"],x[1]),
                                  match(subset.filtered.regulon6.1[,"EgID_TG"],x[2])),
                            1, function(y) sum(!is.na(y))) == 2 ;
                          if (sum(regdbmask) > 0)
                            (1:dim(subset.filtered.regulon6.1)[1])[regdbmask]
                          else
                             NA
                        })

isinRegDB <- matrix(c("present","absent"),
                    nrow=2, ncol=length(idxRegDB))[t(cbind(!is.na(idxRegDB),
                    is.na(idxRegDB)))]


###################################################
### chunk number 37: getthenet
###################################################
#line 522 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
txregnet <- data.frame(RegulonDB=isinRegDB,
                       RegDBdir=subset.filtered.regulon6.1[idxRegDB,"Direction"],
                       AvgNRR=round(nrrs,digits=2),
                       PCC.rho=round(pccs.rho,digits=2),
                       PCC.pva=format(pccs.pva,scientific=TRUE,digits=3),
                       PAC.rho=round(pacs.rho,digits=2),
                       PAC.pva=format(pacs.pva,scientific=TRUE,digits=3))
rownames(txregnet) <- paste(edSymbols[,1],edSymbols[,2],sep=" -> ")


###################################################
### chunk number 38: getthenet
###################################################
#line 536 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
txregnet[sort(txregnet[["AvgNRR"]],index.return=TRUE)$ix,]


###################################################
### chunk number 39: getthenet eval=FALSE
###################################################
## #line 549 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
## postscript(file="qpTRnet50pctpre.eps", onefile=FALSE, paper="a4",
##            pointsize=12, horizontal=FALSE, height=7, width=7)


###################################################
### chunk number 40: getthenet
###################################################
#line 553 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
qpPlotNetwork(g, pairup.i=largestIQRgenesO2netTFs, pairup.j=largestIQRgenesO2net,
              annotation="org.EcK12.eg.db")


###################################################
### chunk number 41: getthenet eval=FALSE
###################################################
## #line 557 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
## dev.off()


###################################################
### chunk number 42: info
###################################################
#line 563 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpi3PO5f/R.INSTALL32a77c04/qpgraph/inst/doc/qpTxRegNet.Rnw"
toLatex(sessionInfo())


