###################################################
### chunk number 1: loadlibs
###################################################
#line 61 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4qErpx/R.INSTALL7110316d/ppiStats/inst/doc/ppiStats.Rnw"
library("ppiStats")
library("ppiData")


###################################################
### chunk number 2: getGavinData
###################################################
#line 81 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4qErpx/R.INSTALL7110316d/ppiStats/inst/doc/ppiStats.Rnw"
data(Gavin2002BPGraph)
data(Gavin2006BPGraph)
GavinGraphs = list(Gavin02=Gavin2002BPGraph,Gavin06=Gavin2006BPGraph)
GavinGraphs


###################################################
### chunk number 3: summaryTables
###################################################
#line 109 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4qErpx/R.INSTALL7110316d/ppiStats/inst/doc/ppiStats.Rnw"
summaryTables = createSummaryTables(GavinGraphs)
summaryTables


###################################################
### chunk number 4: viabilityCharts
###################################################
#line 120 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4qErpx/R.INSTALL7110316d/ppiStats/inst/doc/ppiStats.Rnw"
viabilityCharts(GavinGraphs)


###################################################
### chunk number 5: findVBVPVBPsets
###################################################
#line 136 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4qErpx/R.INSTALL7110316d/ppiStats/inst/doc/ppiStats.Rnw"
GavinViableProteins = lapply(GavinGraphs,FUN=idViableProteins)
sapply(GavinViableProteins,FUN=function(x) lapply(x,FUN=length))

Gavin06VBPproteins =  GavinViableProteins[["Gavin06"]]$VBP
Gavin06VBPproteins[1:4]


###################################################
### chunk number 6: inOutScatterCharts
###################################################
#line 158 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4qErpx/R.INSTALL7110316d/ppiStats/inst/doc/ppiStats.Rnw"
inOutScatterCharts(GavinGraphs)


###################################################
### chunk number 7: sepSystematicStochastic
###################################################
#line 213 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4qErpx/R.INSTALL7110316d/ppiStats/inst/doc/ppiStats.Rnw"

systematicVBPsGavin06 = idSystematic(Gavin2006BPGraph,Gavin06VBPproteins,bpGraph=TRUE)

unbiasedGavin06VBPs = setdiff(Gavin06VBPproteins,systematicVBPsGavin06)

Gavin06VBPsubgraph = subGraph(unbiasedGavin06VBPs,Gavin2006BPGraph)
Gavin06VBPsubgraph


###################################################
### chunk number 8: estimateStochasticErrorProbabilities
###################################################
#line 242 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4qErpx/R.INSTALL7110316d/ppiStats/inst/doc/ppiStats.Rnw"
data(ScISIC)

Gavin06m = as(Gavin06VBPsubgraph,"matrix")
errorProbabilities = estimateCCMErrorRates(Gavin06m,ScISIC)

pTPestimate = errorProbabilities$globalpTP
pFPestimate =errorProbabilities$globalpFP
solutionManifold = errorProbabilities$probPairs

pTPestimate
pFPestimate


###################################################
### chunk number 9: plotErrorEstimates
###################################################
#line 259 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4qErpx/R.INSTALL7110316d/ppiStats/inst/doc/ppiStats.Rnw"
plot(solutionManifold[,"pFPs"],solutionManifold[,"pFNs"],type="l",col="violet",xlab="pFP",ylab="1-pTP")
points(pFPestimate,1-pTPestimate,cex=3,pch=8,col="turquoise")


###################################################
### chunk number 10: inoutStats
###################################################
#line 278 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4qErpx/R.INSTALL7110316d/ppiStats/inst/doc/ppiStats.Rnw"
Gavin06VBPobserved = calcInOutDegStats(Gavin06VBPsubgraph)
Gavin06VBPobserved$unrecipInDegree[5:10]
Gavin06VBPobserved$unrecipOutDegree[5:10]
Gavin06VBPobserved$recipIn[5:10]


###################################################
### chunk number 11: estimateDegree
###################################################
#line 289 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4qErpx/R.INSTALL7110316d/ppiStats/inst/doc/ppiStats.Rnw"
Gavin06VBPdegree = degreeEstimates(Gavin06m,pTPestimate,pFPestimate)
Gavin06VBPdegree[5:10]



###################################################
### chunk number 12: sessionInfo
###################################################
#line 302 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4qErpx/R.INSTALL7110316d/ppiStats/inst/doc/ppiStats.Rnw"
sessionInfo()


