###################################################
### chunk number 1: 
###################################################
#line 60 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpfMb79e/R.INSTALL789526ed/pcaMethods/inst/doc/outliers.Rnw"
library(pcaMethods)


###################################################
### chunk number 2: 
###################################################
#line 63 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpfMb79e/R.INSTALL789526ed/pcaMethods/inst/doc/outliers.Rnw"
data(metaboliteDataComplete)
mdc          <- scale(metaboliteDataComplete, center=TRUE, scale=FALSE)
cond         <- runif(length(mdc)) < 0.05;
mdcOut       <- mdc; mdcOut[cond] <- 10


###################################################
### chunk number 3: 
###################################################
#line 70 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpfMb79e/R.INSTALL789526ed/pcaMethods/inst/doc/outliers.Rnw"
resSvd       <- pca(mdc, method = "svd", nPcs = 5, center = FALSE)
resSvdOut    <- pca(mdcOut, method = "svd", nPcs = 5, center = FALSE)
resRobSvd    <- pca(mdcOut, method = "robustPca", nPcs = 5, center = FALSE)


###################################################
### chunk number 4: 
###################################################
#line 77 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpfMb79e/R.INSTALL789526ed/pcaMethods/inst/doc/outliers.Rnw"
mdcNa        <- mdc;
mdcNa[cond]  <- NA
resPPCA      <- pca(mdcNa, method = "ppca", nPcs = 5, center = FALSE)


###################################################
### chunk number 5: 
###################################################
#line 88 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpfMb79e/R.INSTALL789526ed/pcaMethods/inst/doc/outliers.Rnw"
par(mar=c(5, 6, 4, 2))
par(mfrow=c(2,2))
plot(resSvd@loadings[,1], resSvdOut@loadings[,1], 
xlab = "Loading 1 SVD", ylab = "Loading 1 SVD with outliers",
cex.lab = 3, cex.axis = 2, cex = 3, lwd = 3)
plot(resSvd@loadings[,1], resRobSvd@loadings[,1],
xlab = "Loading 1 SVD", ylab = "Loading 1 robustSVD with outliers",
cex.lab = 3, cex.axis = 2, cex = 3, lwd = 3)
plot(resSvd@loadings[,1], resPPCA@loadings[,1],
xlab = "Loading 1 SVD", ylab = "Loading 1 PPCA with outliers = NA",
cex.lab = 3, cex.axis = 2, cex = 3, lwd = 3)
plot(resRobSvd@loadings[,1], resPPCA@loadings[,1],
xlab = "Loading 1 roubst SVD with outliers", ylab = "Loading 1 svdImpute with outliers = NA",
cex.lab = 3, cex.axis = 2, cex = 3, lwd = 3)


