###################################################
### chunk number 1: loadGraph
###################################################
#line 43 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
library(graph)


###################################################
### chunk number 2: creategraphBAM
###################################################
#line 66 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
df <- data.frame(from = c("SEA", "SFO", "SEA", "LAX", "SEA"),
                   to = c("SFO", "LAX", "LAX", "SEA", "DEN"),
               weight = c( 90, 96, 124, 115, 259))
g <- graphBAM(df, edgemode = "directed")
g 


###################################################
### chunk number 3: nodeAndWeights
###################################################
#line 78 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
nodes(g)
edgeWeights(g, index = c("SEA", "LAX"))


###################################################
### chunk number 4: addNodeEdge
###################################################
#line 88 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
g <- addNode("IAH", g)
g <- addEdge(from = "DEN", to = "IAH", graph = g, weight = 120)
g


###################################################
### chunk number 5: removeEdge
###################################################
#line 99 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
g <- removeEdge(from ="DEN", to = "IAH", g)
g <- removeNode(node = "IAH", g)
g


###################################################
### chunk number 6: subGraph
###################################################
#line 108 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
g <- subGraph(snodes = c("DEN","LAX", "SEA"), g)
g


###################################################
### chunk number 7: fromTo
###################################################
#line 116 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
extractFromTo(g)


###################################################
### chunk number 8: loadData1
###################################################
#line 132 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
data("esetsFemale")
data("esetsMale")


###################################################
### chunk number 9: dataFrames
###################################################
#line 141 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
dfMale <- esetsMale[["brain"]]
dfFemale <- esetsFemale[["brain"]]
head(dfMale)


###################################################
### chunk number 10: creategraphBAMs
###################################################
#line 147 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
male <- graphBAM(dfMale, edgemode = "directed")
female <- graphBAM(dfFemale, edgemode = "directed")


###################################################
### chunk number 11: bamIntersect
###################################################
#line 161 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
intrsct <- graphIntersect(male, female, edgeFun=list(weight =  sum))
intrsct


###################################################
### chunk number 12: removeEdges
###################################################
#line 174 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
resWt <- removeEdgesByWeight(intrsct, lessThan = 1.5)


###################################################
### chunk number 13: updateColor
###################################################
#line 186 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
ftSub <- extractFromTo(resWt)
edgeData(male, from = as.character(ftSub[,"from"]), 
        to = as.character(ftSub[,"to"]), attr = "color") <- "red"

edgeData(female, from = as.character(ftSub[,"from"]), 
        to = as.character(ftSub[,"to"]), attr = "color") <- "red"



###################################################
### chunk number 14: loadRBGL
###################################################
#line 217 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
library(graph)
library(RBGL)


###################################################
### chunk number 15: createDataFrames
###################################################
#line 236 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
ft1 <- data.frame(
        from = c("SEA", "SFO", "SEA", "LAX", "SEA"),
          to = c("SFO", "LAX", "LAX", "SEA", "DEN"),
      weight = c( 90, 96, 124, 115, 259))

ft2 <- data.frame(
        from = c("SEA", "SFO", "SEA", "LAX", "SEA", "DEN", "SEA", "IAH", "DEN"),
          to = c("SFO", "LAX", "LAX", "SEA", "DEN", "IAH", "IAH", "DEN", "BWI"),
       weight= c(169, 65, 110, 110, 269, 256, 304, 256, 271))

ft3 <- data.frame( 
   from = c("SEA", "SFO", "SEA", "LAX", "SEA", "DEN", "SEA", "IAH", "DEN", "BWI"),
    to  = c("SFO", "LAX", "LAX", "SEA", "DEN", "IAH", "IAH", "DEN", "BWI", "SFO"),
 weight = c(237, 65, 156, 139, 281, 161, 282, 265, 298, 244))

ft4 <- data.frame( 
    from = c("SEA", "SFO", "SEA", "SEA", "DEN", "SEA", "BWI"),
     to  = c("SFO", "LAX", "LAX", "DEN", "IAH", "IAH", "SFO"),
  weight = c(237, 60, 125, 259, 265, 349, 191))


###################################################
### chunk number 16: createMG
###################################################
#line 264 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
esets <- list(Alaska = ft1, United = ft2, Delta = ft3, American = ft4)
mg <- MultiGraph(esets, directed = TRUE)
mg


###################################################
### chunk number 17: cities
###################################################
#line 272 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
nodes(mg)


###################################################
### chunk number 18: DeltafromSeattle
###################################################
#line 279 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
mgEdgeData(mg, "Delta", from = "SEA", attr = "weight")


###################################################
### chunk number 19: nodeData
###################################################
#line 288 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
nodeData(mg, n = c("SEA", "DEN", "IAH", "LAX", "SFO"), attr = "shape")  <- 
    c("triangle", "circle", "circle", "circle", "circle")


###################################################
### chunk number 20: nodeDataVal
###################################################
#line 296 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
nodeData(mg,  attr = "shape")  


###################################################
### chunk number 21: edgeDataVal
###################################################
#line 305 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
mgEdgeData(mg, "Delta", attr = "color")   <- "red"
mgEdgeData(mg, "Delta", from = c("SEA", "SEA", "SEA", "SEA"), 
        to = c("DEN", "IAH", "LAX", "SFO"), attr = "color") <- "green"


###################################################
### chunk number 22: mgEdgeDataVal
###################################################
#line 311 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
mgEdgeData(mg, "Delta", attr = "color")


###################################################
### chunk number 23: subsetMG
###################################################
#line 320 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
g <- subsetEdgeSets(mg, edgeSets = c("Alaska", "United", "Delta"))


###################################################
### chunk number 24: intersecmg
###################################################
#line 334 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
edgeFun <- list( weight = min)
gInt <- edgeSetIntersect0(g, edgeFun = edgeFun)
gInt


###################################################
### chunk number 25: intersectWeights
###################################################
#line 343 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
mgEdgeData(gInt, "Alaska_United_Delta", attr= "weight")


###################################################
### chunk number 26: loadData
###################################################
#line 359 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
data("esetsFemale")
data("esetsMale")
names(esetsFemale)
head(esetsFemale$brain)


###################################################
### chunk number 27: createMultiGraphs
###################################################
#line 378 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
female  <- MultiGraph(edgeSets = esetsFemale, directed = TRUE)
male  <- MultiGraph(edgeSets = esetsMale, directed = TRUE )
male
female


###################################################
### chunk number 28: graphBAMs
###################################################
#line 399 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
maleBrain <- extractGraphBAM(male, "brain")[["brain"]]
maleBrain
femaleBrain <-  extractGraphBAM(female, "brain")[["brain"]]


###################################################
### chunk number 29: edgeDistance
###################################################
#line 409 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
maleWt <- bellman.ford.sp(maleBrain, start = c("10024416717"))$distance
maleWt <- maleWt[maleWt != Inf & maleWt != 0]
maleWt

femaleWt <- bellman.ford.sp(femaleBrain, start = c("10024416717"))$distance
femaleWt <- femaleWt[femaleWt != Inf & femaleWt != 0]
femaleWt


###################################################
### chunk number 30: nodeAttr
###################################################
#line 424 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
nodeData(male, attr = "color") <- "gray"
nodeData(male , n = c("10024416717", names(maleWt)), attr = "color" ) <- c("red")

nodeData(female, attr = "color") <- "gray"
nodeData(female , n = c("10024416717", names(femaleWt)), attr = "color" ) <- c("red")


###################################################
### chunk number 31: nodeSub
###################################################
#line 439 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp4ztuDc/R.INSTALL421a2a35/graph/inst/doc/MultiGraphClass.Rnw"
resInt <- graphIntersect(male, female)
resInt


