###################################################
### chunk number 1: setup
###################################################
#line 22 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpcM2CHL/R.INSTALL2d93272/genomes/inst/doc/genome-tables.Rnw"
library(genomes)
options(warn=-1, width=75, digits=2, scipen=3,  "prompt" = "R> ", "continue" = " ")
options(SweaveHooks=list(fig=function() par(mar=c(5,4.2,1,1))))


###################################################
### chunk number 2: biocLite eval=FALSE
###################################################
## #line 46 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpcM2CHL/R.INSTALL2d93272/genomes/inst/doc/genome-tables.Rnw"
## source("http://bioconductor.org/biocLite.R")
## biocLite("genomes")


###################################################
### chunk number 3: install eval=FALSE
###################################################
## #line 54 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpcM2CHL/R.INSTALL2d93272/genomes/inst/doc/genome-tables.Rnw"
## install.packages("genomes", 
##    repos="http://www.bioconductor.org/packages/release/bioC")


###################################################
### chunk number 4: install eval=FALSE
###################################################
## #line 69 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpcM2CHL/R.INSTALL2d93272/genomes/inst/doc/genome-tables.Rnw"
## install.packages("genomes", 
##    repos="http://www.bioconductor.org/packages/devel/bioC")


###################################################
### chunk number 5: lproks
###################################################
#line 90 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpcM2CHL/R.INSTALL2d93272/genomes/inst/doc/genome-tables.Rnw"
data(lproks)
lproks
summary(lproks)
plot(lproks, log='y', las=1)
data(leuks)
data(lenvs)
lines(leuks, col="red")
lines(lenvs, col="green3")
legend("topleft", c("Microbes", "Eukaryotes", "Metagenomes"),
         lty=1,  bty='n', col=c("blue", "red", "green3"))


###################################################
### chunk number 6: complete
###################################################
#line 118 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpcM2CHL/R.INSTALL2d93272/genomes/inst/doc/genome-tables.Rnw"
complete<-subset(lproks, status=="Complete")
doublingTime(complete)
x<-table(format(complete$released, "%Y"))
barplot(x, col="blue", ylim=c(0,max(x)*1.04), space=0.5, las=1,
axis.lty=1, xlab="Year", ylab="Genomes per year")
box()


###################################################
### chunk number 7: top
###################################################
#line 142 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpcM2CHL/R.INSTALL2d93272/genomes/inst/doc/genome-tables.Rnw"
table2(species(lproks$name))


###################################################
### chunk number 8: yersinia
###################################################
#line 153 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpcM2CHL/R.INSTALL2d93272/genomes/inst/doc/genome-tables.Rnw"
## Yersinia pestis
yp<-subset(lproks, name %like% 'Yersinia pestis*')
plotby(yp, labels=TRUE, cex=.5, lbty='n')



###################################################
### chunk number 9: <gold
###################################################
#line 183 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpcM2CHL/R.INSTALL2d93272/genomes/inst/doc/genome-tables.Rnw"
data(gold)
obligate<-subset(gold, symbiotic.interaction=="Endosymbiotic intracellular", 
c(goldstamp, name, phenotype))
obligate$pathogen<-"Pathogen"
obligate$pathogen[ obligate$phenotype %like% "Non-*|Symb*|Carb"]<-"Commensal"
obligate$pathogen[ obligate$phenotype ==""]<-"Commensal"
table2(genus(obligate$name), obligate$pathogen)


## split comma separated list of phenotypes
x<-subset(gold, phenotype!="")
x2<-strsplit(x$phenotype, ", ")
gold2<- as.data.frame(
 cbind(goldstamp = rep(x$goldstamp, sapply(x2, length)),
            name = rep(x$name, sapply(x2, length)),
       phenotype = unlist(x2)) )
table2(gold2$phenotype)
subset(gold2, phenotype %like% 'Arsenic metabol*')


