###################################################
### chunk number 1: poisson
###################################################
#line 2733 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp72KiQ4/R.INSTALL3685454f/edgeR/inst/doc/edgeR.Rnw"
library(edgeR)
set.seed(101)
n <- 10000
lib.sizes <- c(40000,50000,38000,40000)
p <- runif(n,min=.0001,.001)
mu <- outer(p,lib.sizes)
mu[1:5,3:4]<-mu[1:5,3:4]*8
y <- matrix(rpois(4*n,lambda=mu),nrow=n)
dP <- DGEList(counts=y,group=rep(1:2,each=2),lib.size=lib.sizes)
dP$common.lib.size <- exp(mean(log(dP$samples$lib.size)))


###################################################
### chunk number 2: poissonstats
###################################################
#line 2748 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp72KiQ4/R.INSTALL3685454f/edgeR/inst/doc/edgeR.Rnw"
de.P <- exactTest(dP, dispersion=1e-06) # Set dispersion close to zero to allow exact test for Poisson data
topTags(de.P)


###################################################
### chunk number 3: setup
###################################################
#line 2774 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp72KiQ4/R.INSTALL3685454f/edgeR/inst/doc/edgeR.Rnw"
sessionInfo()


