###################################################
### chunk number 1: setup
###################################################
#line 28 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpbX2oBe/R.INSTALL53f71ba1/charm/inst/doc/charm.Rnw"
options(width=60)
options(continue=" ")
options(prompt="R> ")


###################################################
### chunk number 2: loadCharm
###################################################
#line 59 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpbX2oBe/R.INSTALL53f71ba1/charm/inst/doc/charm.Rnw"
library(charm)
library(charmData)


###################################################
### chunk number 3: dataDir
###################################################
#line 66 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpbX2oBe/R.INSTALL53f71ba1/charm/inst/doc/charm.Rnw"
dataDir <- system.file("data", package="charmData")
dataDir


###################################################
### chunk number 4: phenodata
###################################################
#line 72 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpbX2oBe/R.INSTALL53f71ba1/charm/inst/doc/charm.Rnw"
phenodataDir <- system.file("extdata", package="charmData")
pd <- read.delim(file.path(phenodataDir, "phenodata.txt"))
phenodataDir
pd


###################################################
### chunk number 5: validatePd
###################################################
#line 90 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpbX2oBe/R.INSTALL53f71ba1/charm/inst/doc/charm.Rnw"
res <- validatePd(pd)


###################################################
### chunk number 6: readData
###################################################
#line 96 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpbX2oBe/R.INSTALL53f71ba1/charm/inst/doc/charm.Rnw"
rawData <- readCharm(files=pd$filename, path=dataDir, sampleKey=pd)
rawData


###################################################
### chunk number 7: qc
###################################################
#line 106 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpbX2oBe/R.INSTALL53f71ba1/charm/inst/doc/charm.Rnw"
qual <- qcReport(rawData, file="qcReport.pdf")
qual


###################################################
### chunk number 8: getControlIndex
###################################################
#line 122 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpbX2oBe/R.INSTALL53f71ba1/charm/inst/doc/charm.Rnw"
library(BSgenome.Hsapiens.UCSC.hg18)
ctrlIdx <- getControlIndex(rawData, subject=Hsapiens)


###################################################
### chunk number 9: methp_density
###################################################
#line 130 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpbX2oBe/R.INSTALL53f71ba1/charm/inst/doc/charm.Rnw"
grp <- pData(rawData)$tissue
p <- methp(rawData, controlIndex=ctrlIdx, 
	plotDensity="density.pdf", plotDensityGroups=grp) 
head(p)


###################################################
### chunk number 10: dmrFinder
###################################################
#line 141 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpbX2oBe/R.INSTALL53f71ba1/charm/inst/doc/charm.Rnw"
dmr <- dmrFinder(rawData, p=p, groups=grp, 
	compare=c("colon", "liver",
	  		  "colon", "spleen"))


###################################################
### chunk number 11: headDmr
###################################################
#line 146 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpbX2oBe/R.INSTALL53f71ba1/charm/inst/doc/charm.Rnw"
names(dmr)
names(dmr$tabs)
head(dmr$tabs[[1]])


###################################################
### chunk number 12: 
###################################################
#line 169 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpbX2oBe/R.INSTALL53f71ba1/charm/inst/doc/charm.Rnw"
sessionInfo()


