###################################################
### chunk number 1: setup1
###################################################
#line 72 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/twoWay.Rnw"
library("cellHTS2")


###################################################
### chunk number 2: setup2
###################################################
#line 76 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/twoWay.Rnw"
## for debugging:
options(error=recover)


###################################################
### chunk number 3: dataPath
###################################################
#line 105 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/twoWay.Rnw"
experimentName <- "TwoWayAssay"
dataPath <- system.file(experimentName, package="cellHTS2") 


###################################################
### chunk number 4: source import function
###################################################
#line 124 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/twoWay.Rnw"
source(file.path(dataPath, "importData.R"))


###################################################
### chunk number 5: readPlateData
###################################################
#line 129 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/twoWay.Rnw"
x <- readPlateList("Platelist.txt", name=experimentName,
                   importFun=importData, path=dataPath)


###################################################
### chunk number 6: showX
###################################################
#line 134 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/twoWay.Rnw"
x


###################################################
### chunk number 7: plateFileTable
###################################################
#line 141 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/twoWay.Rnw"
cellHTS2:::tableOutput(file.path(dataPath, "Platelist.txt"), selRows=1, 
  "plate list", preName="twoWay")


###################################################
### chunk number 8: configure the data
###################################################
#line 161 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/twoWay.Rnw"
x <- configure(x, descripFile = "Description.txt",
               confFile="Plateconf.txt", path=dataPath)


###################################################
### chunk number 9: well annottaion
###################################################
#line 176 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/twoWay.Rnw"
table(wellAnno(x))


###################################################
### chunk number 10: annotate the data
###################################################
#line 192 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/twoWay.Rnw"
x <- annotate(x, geneIDFile="GeneIDs.txt", path=dataPath)


###################################################
### chunk number 11: plateConfscreenLogTable
###################################################
#line 197 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/twoWay.Rnw"
cellHTS2:::tableOutputWithHeaderRows(file.path(dataPath, "Plateconf.txt"), 
                                     "plate configuration", selRows=NULL, preName="twoWay")


###################################################
### chunk number 12: geneIDsTable
###################################################
#line 202 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/twoWay.Rnw"
cellHTS2:::tableOutput(file.path(dataPath, "GeneIDs.txt"), "gene ID", 
                       selRows = 3:6, preName="twoWay")


###################################################
### chunk number 13: define controls
###################################################
#line 233 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/twoWay.Rnw"
negCtr <- "(?i)^GFP$|^mock$"
posCtr <- list(act = "(?i)^AATK$|^ATTK$", inh = "(?i)^MAP2K6$")


###################################################
### chunk number 14: writeReport1Show eval=FALSE
###################################################
## #line 241 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/twoWay.Rnw"
## setSettings(list(platelist=list(intensities=list(range=c(300, 4000), 
##                                                  include=TRUE))))
## out <- writeReport(raw=x, outdir="2Wraw",
##                    posControls=posCtr, negControls=negCtr)


###################################################
### chunk number 15: writeReport1Do
###################################################
#line 248 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/twoWay.Rnw"
setSettings(list(platelist=list(intensities=list(range=c(300, 4000), 
                                                 include=TRUE))))
out <- writeReport(raw=x, force=TRUE, outdir="2Wraw", 
                   posControls=posCtr, negControls=negCtr) 


###################################################
### chunk number 16: browseReport1 eval=FALSE
###################################################
## #line 258 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/twoWay.Rnw"
## browseURL(out)


###################################################
### chunk number 17: normalization
###################################################
#line 272 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/twoWay.Rnw"
xn <- normalizePlates(x, scale="multiplicative", log=TRUE, method ="negatives", 
                      varianceAdjust="none", negControls = negCtr)


###################################################
### chunk number 18: get the data as an array
###################################################
#line 283 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/twoWay.Rnw"
xnorm <- Data(xn)
dim(xnorm)


###################################################
### chunk number 19: score and summarize replicates
###################################################
#line 296 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/twoWay.Rnw"
xsc <- scoreReplicates(xn, sign="+", method="zscore") 
xsc <- summarizeReplicates(xsc, summary="mean") 


###################################################
### chunk number 20: boxplotzscore
###################################################
#line 307 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/twoWay.Rnw"
ylim <- quantile(Data(xsc), c(0.001, 0.999), na.rm=TRUE)
wa <- factor(as.character(wellAnno(xsc)), exclude="empty")   # to exclude "empty" wells
boxplot(Data(xsc) ~ wa, col="lightblue", main="scores", outline=FALSE, ylim=ylim, xaxt="n")
lab <- unique(plateConf(xsc)$Content)
lab <- lab[match(levels(wa), tolower(lab))]
axis(1, at=c(1:nlevels(wa)), labels=lab)


###################################################
### chunk number 21: report2Show eval=FALSE
###################################################
## #line 324 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/twoWay.Rnw"
## setSettings(list(platelist=list(intensities=list(range=c(-1, 1), include=TRUE)),
##                  screenSummary=list(scores=list(range=c(-2,3)))))
## out <- writeReport(raw=x, normalized=xn, scored=xsc, 
##                    outdir="2Wnormalized", posControls=posCtr, negControls=negCtr)


###################################################
### chunk number 22: report2Do
###################################################
#line 330 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/twoWay.Rnw"
setSettings(list(platelist=list(intensities=list(range=c(-1, 1), include=TRUE)),
                 screenSummary=list(scores=list(range=c(-2,3)))))
out <- writeReport(raw=x, normalized=xn, scored=xsc, 
                   outdir="2Wnormalized", posControls=posCtr, negControls=negCtr, 
                   force=TRUE)


###################################################
### chunk number 23: browse2 eval=FALSE
###################################################
## #line 337 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/twoWay.Rnw"
## browseURL(out)


###################################################
### chunk number 24: savex
###################################################
#line 349 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/twoWay.Rnw"
save(xsc, file=paste(experimentName, ".rda", sep=""))


###################################################
### chunk number 25: sessionInfo
###################################################
#line 361 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/twoWay.Rnw"
toLatex(sessionInfo())


