###################################################
### chunk number 1: Ropts
###################################################
#line 47 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
options(width=70)


###################################################
### chunk number 2: install eval=FALSE
###################################################
## #line 89 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
## source("http://www.bioconductor.org/biocLite.R")
## biocLite("cellHTS2")


###################################################
### chunk number 3: setup1
###################################################
#line 102 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
library("cellHTS2")


###################################################
### chunk number 4: dataPath
###################################################
#line 149 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
experimentName <- "KcViab"
dataPath <- system.file(experimentName, package="cellHTS2") 


###################################################
### chunk number 5: dirDataPath
###################################################
#line 160 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
dataPath
rev(dir(dataPath))[1:12]


###################################################
### chunk number 6: readPlateList
###################################################
#line 167 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
x <- readPlateList("Platelist.txt", 
                   name=experimentName, 
                   path=dataPath)


###################################################
### chunk number 7: showX
###################################################
#line 173 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
x


###################################################
### chunk number 8: plateFileTable
###################################################
#line 184 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
cellHTS2:::tableOutput(file.path(dataPath, "Platelist.txt"), "plate list")
cellHTS2:::tableOutput(file.path(dataPath, names(intensityFiles(x))[1]), 
              "signal intensity", header=FALSE)


###################################################
### chunk number 9: see object state
###################################################
#line 364 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
state(x)


###################################################
### chunk number 10: writeReport
###################################################
#line 425 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
out <- writeReport(raw=x, force = TRUE, outdir = "report-raw")


###################################################
### chunk number 11: printout
###################################################
#line 452 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
out


###################################################
### chunk number 12: browseReport1 eval=FALSE
###################################################
## #line 458 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
## browseURL(out)


###################################################
### chunk number 13: annotatePlateRes
###################################################
#line 500 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
x <- configure(x,
               descripFile="Description.txt", 
               confFile="Plateconf.txt", 
               logFile="Screenlog.txt", 
               path=dataPath)


###################################################
### chunk number 14: plateConfscreenLogTable
###################################################
#line 517 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
cellHTS2:::tableOutputWithHeaderRows(file.path(dataPath, "Plateconf.txt"), 
  "plate configuration", selRows=NULL)
cellHTS2:::tableOutput(file.path(dataPath, "Screenlog.txt"), 
  "screen log", selRows=1:3)


###################################################
### chunk number 15: 
###################################################
#line 580 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
table(wellAnno(x))


###################################################
### chunk number 16: configurationplot
###################################################
#line 587 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
configurationAsScreenPlot(x, legend=TRUE)


###################################################
### chunk number 17: normalizePlateMedian
###################################################
#line 792 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
xn <- normalizePlates(x, 
                      scale="multiplicative", 
                      log=FALSE, 
                      method="median", 
                      varianceAdjust="none")


###################################################
### chunk number 18: compare cellHTs objects
###################################################
#line 809 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
compare2cellHTS(x, xn)


###################################################
### chunk number 19: score replicates
###################################################
#line 833 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
xsc <- scoreReplicates(xn, sign="-", method="zscore") 


###################################################
### chunk number 20: summarize replicates
###################################################
#line 865 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
xsc <- summarizeReplicates(xsc, summary="mean") 


###################################################
### chunk number 21: boxplotzscore
###################################################
#line 875 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
scores <- Data(xsc)
ylim <- quantile(scores, c(0.001, 0.999), na.rm=TRUE)
boxplot(scores ~ wellAnno(x), 
        col="lightblue", outline=FALSE, ylim=ylim)


###################################################
### chunk number 22: callvalues
###################################################
#line 909 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
y <- scores2calls(xsc, z0=1.5, lambda=2)
png("cellhts2-callvalues.png")
plot(Data(xsc), Data(y), col="blue", pch=".",
     xlab="z-scores", ylab="calls", 
     main=expression(1/(1+e^{-lambda *(z-z[0])})))
dev.off()


###################################################
### chunk number 23: callvaluesShow eval=FALSE
###################################################
## #line 917 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
## y <- scores2calls(xsc, z0=1.5, lambda=2)
## plot(Data(xsc), Data(y), col="blue", pch=".",
##      xlab="z-scores", ylab="calls", 
##      main=expression(1/(1+e^{-lambda *(z-z[0])})))


###################################################
### chunk number 24: geneIDs
###################################################
#line 948 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
xsc <- annotate(xsc, geneIDFile="GeneIDs_Dm_HFA_1.1.txt", 
                path=dataPath)


###################################################
### chunk number 25: geneIDsTable
###################################################
#line 953 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
cellHTS2:::tableOutput(file.path(dataPath, "GeneIDs_Dm_HFA_1.1.txt"), 
     "gene ID", selRows = 3:6)


###################################################
### chunk number 26: printxagain
###################################################
#line 972 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
xsc


###################################################
### chunk number 27: savex
###################################################
#line 978 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
save(xsc, file=paste(experimentName, ".rda", sep=""))


###################################################
### chunk number 28: writeReport2
###################################################
#line 990 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
setSettings(list(plateList=list(reproducibility=list(include=TRUE, map=TRUE), 
                                intensities=list(include=TRUE, map=TRUE)),
                 screenSummary=list(scores=list(range=c(-4, 8), map=TRUE))))
out = writeReport(raw=x, normalized=xn, scored=xsc, 
                  force = TRUE, outdir = "report-normalized") 


###################################################
### chunk number 29: browseReport2 eval=FALSE
###################################################
## #line 1000 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
## browseURL(out)


###################################################
### chunk number 30: imageScreen eval=FALSE
###################################################
## #line 1062 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
## imageScreen(xsc, ar=1, zrange=c(-3,4))


###################################################
### chunk number 31: exportData eval=FALSE
###################################################
## #line 1169 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
## writeTab(xsc, file="Scores.txt")


###################################################
### chunk number 32: exportOtherData eval=FALSE
###################################################
## #line 1182 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
## # determine the ratio between each well and the plate median
## y <- array(as.numeric(NA), dim=dim(Data(x)))
## nrWell <- prod(pdim(x))
## nrPlate <- max(plate(x))
## for(p in 1:nrPlate) 
## {
##     j <- (1:nrWell)+nrWell*(p-1)
##     samples <- wellAnno(x)[j]=="sample"
##     y[j, , ] <- apply(Data(x)[j, , , drop=FALSE], 2:3, 
##                       function(w) w/median(w[samples], 
##                                            na.rm=TRUE)) 
## }
## 
## y+signif(y, 3)
## out <- y[,,1]
## out <- cbind(fData(xsc), out)
## names(out) <- c(names(fData(xsc)), 
## sprintf("Well/Median_r%d_ch%d", rep(1:dim(y)[2], dim(y)[3]), 
## rep(1:dim(y)[3], each=dim(y)[2])))
## write.tabdel(out, file="WellMedianRatio.txt")


###################################################
### chunk number 33: example for description file
###################################################
#line 1250 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
out <- templateDescriptionFile("template-Description.txt", 
                               force=TRUE)
out
readLines(out)


###################################################
### chunk number 34: old plateConfscreenLogTable
###################################################
#line 1262 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
cellHTS2:::tableOutput(file.path(dataPath, "old-Plateconf.txt"), 
  "cellHTS package-specific plate configuration", selRows=1:28)
cellHTS2:::tableOutput(file.path(dataPath, "old-Screenlog.txt"), 
  "cellHTS package-specific screen log", selRows=1:3)


###################################################
### chunk number 35: Z score method eval=FALSE
###################################################
## #line 1428 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
##  xZ <- normalizePlates(x, scale="additive", log=FALSE, 
##          method="median", varianceAdjust="byPlate") 


###################################################
### chunk number 36: transfplots
###################################################
#line 1560 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
library("vsn")
png("cellhts2-transfplots.png", width=324, height=474)
par(mfcol=c(3,2))
myPlots=function(z,...) 
{
  hist(z[,1], 100, col="lightblue", xlab="",...)
  meanSdPlot(z, ylim=c(0, quantile(abs(z[,2]-z[,1]), 0.95, na.rm=TRUE)), ...)
  qqnorm(z[,1], pch='.', ...)
  qqline(z[,1], col='blue')
}
dv <- Data(xn)[,,1]
myPlots(dv, main="untransformed")
xlog <- normalizePlates(x, scale="multiplicative", log=TRUE, 
                        method="median", varianceAdjust="byExperiment")
dvlog <- Data(xlog)[,,1]
myPlots(dvlog, main="log2")
dev.off()


###################################################
### chunk number 37: transfplotsShow eval=FALSE
###################################################
## #line 1579 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
## library("vsn")
## par(mfcol=c(3,2))
## myPlots=function(z,...) 
## {
##   hist(z[,1], 100, col="lightblue", xlab="",...)
##   meanSdPlot(z, ylim=c(0, quantile(abs(z[,2]-z[,1]), 0.95,
##                                    na.rm=TRUE)), ...)
##   qqnorm(z[,1], pch='.', ...)
##   qqline(z[,1], col='blue')
## }
## dv <- Data(xn)[,,1]
## myPlots(dv, main="untransformed")
## xlog <- normalizePlates(x, scale="multiplicative", log=TRUE, 
##        method="median", varianceAdjust="byExperiment")
## dvlog <- Data(xlog)[,,1]
## myPlots(dvlog, main="log2")


###################################################
### chunk number 38: sessionInfo
###################################################
#line 1613 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpeKF2YX/R.INSTALL2f322215/cellHTS2/inst/doc/cellhts2.Rnw"
toLatex(sessionInfo())


