###################################################
### chunk number 1: 
###################################################
#line 35 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpljZRtc/R.INSTALL616b714f/biocDatasets/inst/doc/synthetic_arrays.Rnw"
library("biocDatasets")


###################################################
### chunk number 2: 
###################################################
#line 49 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpljZRtc/R.INSTALL616b714f/biocDatasets/inst/doc/synthetic_arrays.Rnw"
n_transcripts <- 250
transcripts <- randomDNASequences(n_transcripts, 
                                  sample(300:10000, n_transcripts, 
                                         replace=TRUE))


###################################################
### chunk number 3: 
###################################################
#line 63 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpljZRtc/R.INSTALL616b714f/biocDatasets/inst/doc/synthetic_arrays.Rnw"
n_probes <- 10
len_probe <- 25
ir <- vector("list", length=n_transcripts)
features <- data.frame(seq = I(rep("" ,n_transcripts * n_probes)),
                       target = rep(as.integer(NA), n_transcripts * n_probes))
for (i in 1:n_transcripts) {
  s <- transcripts[[i]]
  ir[[i]] <- randomIRanges(n_probes, len_probe, 
                           1, length(s), replace=FALSE)
  features$seq[(1:n_probes) + (i-1) * n_probes] <-
    as.character(msubseq(s, ir[[i]]))
  features$target[(1:n_probes) + (i-1) * n_probes] <-
    i
}



###################################################
### chunk number 4: 
###################################################
#line 84 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpljZRtc/R.INSTALL616b714f/biocDatasets/inst/doc/synthetic_arrays.Rnw"
summary(duplicated(features$seq))



###################################################
### chunk number 5: 
###################################################
#line 96 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpljZRtc/R.INSTALL616b714f/biocDatasets/inst/doc/synthetic_arrays.Rnw"
ppos <- createProbeCoords(50, 50)


###################################################
### chunk number 6: 
###################################################
#line 102 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpljZRtc/R.INSTALL616b714f/biocDatasets/inst/doc/synthetic_arrays.Rnw"
plot(ppos$x, ppos$y, pch=".")


###################################################
### chunk number 7: 
###################################################
#line 113 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpljZRtc/R.INSTALL616b714f/biocDatasets/inst/doc/synthetic_arrays.Rnw"
scramble_i <- sample(seq(along=ppos$x))
array_layout <- cbind(features, ppos[scramble_i, ])
row.names(array_layout) <- seq(along=array_layout[[1]])


###################################################
### chunk number 8: 
###################################################
#line 128 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpljZRtc/R.INSTALL616b714f/biocDatasets/inst/doc/synthetic_arrays.Rnw"
x <- expression_arraywide(50*50)


###################################################
### chunk number 9: 
###################################################
#line 134 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpljZRtc/R.INSTALL616b714f/biocDatasets/inst/doc/synthetic_arrays.Rnw"
x2 <- replicate_arraywide(x)


###################################################
### chunk number 10: 
###################################################
#line 140 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpljZRtc/R.INSTALL616b714f/biocDatasets/inst/doc/synthetic_arrays.Rnw"
m <- cbind(x, x2)
colnames(m) <- c(1, 2)
rownames(m) <- seq(1, 50*50)


###################################################
### chunk number 11: 
###################################################
#line 147 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpljZRtc/R.INSTALL616b714f/biocDatasets/inst/doc/synthetic_arrays.Rnw"
library(Biobase)
eset <- new("ExpressionSet",
            featureData = new("AnnotatedDataFrame", array_layout),
            exprs = m)


###################################################
### chunk number 12: eset2dataframe
###################################################
#line 159 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpljZRtc/R.INSTALL616b714f/biocDatasets/inst/doc/synthetic_arrays.Rnw"

eset2dataframe <- function(eset){
  pdataf <- pData(eset)
  
  dataf <- lapply(pdataf,
                  function(col) rep(col, 
                                  rep(nrow(exprs(eset)), nrow(pdataf)))
                  )
  dataf <- as.data.frame(dataf)
  dataf <- cbind(exprs = c(exprs(eset)), 
                 array=rep(rownames(pdataf), each=nrow(exprs(eset))), 
                 dataf)
  return(dataf)
}




###################################################
### chunk number 13: 
###################################################
#line 180 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpljZRtc/R.INSTALL616b714f/biocDatasets/inst/doc/synthetic_arrays.Rnw"
sample_a_seed <- expression_arraywide(50*50)

sample_b_seed <- expression_arraywide(50*50)


###################################################
### chunk number 14: 
###################################################
#line 188 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpljZRtc/R.INSTALL616b714f/biocDatasets/inst/doc/synthetic_arrays.Rnw"
m <- vector("list", length=6)
for (i in 1:3) {
  m[[i]] <- replicate_arraywide(sample_a_seed)
  m[[i+3]] <- replicate_arraywide(sample_b_seed)
}

m <- matrix(unlist(m), ncol=6)

sample_data <- data.frame(grp = rep(c('a', 'b'), c(3, 3)))
rownames(sample_data) <- 1:6


###################################################
### chunk number 15: 
###################################################
#line 202 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpljZRtc/R.INSTALL616b714f/biocDatasets/inst/doc/synthetic_arrays.Rnw"

eset <- new("ExpressionSet",
            featureData = new("AnnotatedDataFrame", array_layout),
            exprs = m,
            phenoData = new("AnnotatedDataFrame", 
              sample_data))



###################################################
### chunk number 16: 
###################################################
#line 213 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpljZRtc/R.INSTALL616b714f/biocDatasets/inst/doc/synthetic_arrays.Rnw"

dataf <- eset2dataframe(eset)
library(lattice)
p <- densityplot( ~ exprs | grp, 
                 groups = dataf$array, 
                 data = dataf,
                 pch = ".")
print(p)



